/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.http;

import java.lang.ref.WeakReference;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.conn.ClientConnectionManager;

public class IdleConnectionMonitor {
    private static final long DEFAULT_IDLE_CHECK_INTERVAL = 30L;
    private static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){
        private final AtomicInteger threadCount = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName(String.format("ektorp-idle-connection-monitor-thread-%s", this.threadCount.incrementAndGet()));
            return t;
        }
    });

    public static void monitor(ClientConnectionManager cm) {
        CleanupTask cleanupTask = new CleanupTask(cm);
        ScheduledFuture<?> cleanupFuture = executorService.scheduleWithFixedDelay(cleanupTask, 30L, 30L, TimeUnit.SECONDS);
        cleanupTask.setFuture(cleanupFuture);
    }

    private static class CleanupTask
    implements Runnable {
        private final WeakReference<ClientConnectionManager> cm;
        private ScheduledFuture<?> thisFuture;

        CleanupTask(ClientConnectionManager cm) {
            this.cm = new WeakReference<ClientConnectionManager>(cm);
        }

        public void setFuture(ScheduledFuture<?> future) {
            this.thisFuture = future;
        }

        @Override
        public void run() {
            if (this.cm.get() != null) {
                ((ClientConnectionManager)this.cm.get()).closeExpiredConnections();
            } else if (this.thisFuture != null) {
                this.thisFuture.cancel(false);
            }
        }
    }
}

