/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.ektorp.DbAccessException;
import org.ektorp.DocumentNotFoundException;
import org.ektorp.UpdateConflictException;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.ResponseCallback;

public class StdResponseHandler<T>
implements ResponseCallback<T> {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static DbAccessException createDbAccessException(HttpResponse hr) {
        String body;
        NullNode responseBody;
        try {
            responseBody = StdResponseHandler.responseBodyAsNode(IOUtils.toString((InputStream)hr.getContent()));
        }
        catch (IOException e) {
            responseBody = NullNode.getInstance();
        }
        switch (hr.getCode()) {
            case 404: {
                return new DocumentNotFoundException(hr.getRequestURI(), (JsonNode)responseBody);
            }
            case 409: {
                return new UpdateConflictException();
            }
        }
        try {
            body = StdResponseHandler.toPrettyString((JsonNode)responseBody);
        }
        catch (IOException e) {
            body = "unavailable";
        }
        return new DbAccessException(hr.toString() + "\nURI: " + hr.getRequestURI() + "\nResponse Body: \n" + body);
    }

    private static String toPrettyString(JsonNode n) throws IOException {
        return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)n);
    }

    private static JsonNode responseBodyAsNode(String s) throws IOException {
        if (s == null || s.length() == 0) {
            return NullNode.getInstance();
        }
        if (!s.startsWith("{")) {
            return NullNode.getInstance();
        }
        return MAPPER.readTree(s);
    }

    @Override
    public T error(HttpResponse hr) {
        throw StdResponseHandler.createDbAccessException(hr);
    }

    @Override
    public T success(HttpResponse hr) throws Exception {
        return null;
    }
}

