/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl.changes;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ektorp.changes.DocumentChange;
import org.ektorp.util.Assert;

public class StdDocumentChange
implements DocumentChange {
    private static final String REV_FIELD_NAME = "rev";
    private static final String SEQ_FIELD_NAME = "seq";
    private static final String ID_FIELD_NAME = "id";
    private static final String DOC_FIELD_NAME = "doc";
    private static final String DELETED_FIELD_NAME = "deleted";
    private static final String CHANGES_FIELD_NAME = "changes";
    private final JsonNode node;

    public StdDocumentChange(JsonNode node) {
        Assert.notNull(node, "node may not be null");
        this.node = node;
    }

    @Override
    public int getSequence() {
        return this.node.get(SEQ_FIELD_NAME).intValue();
    }

    @Override
    public String getId() {
        return this.node.get(ID_FIELD_NAME).textValue();
    }

    @Override
    public boolean isDeleted() {
        JsonNode deleted = this.node.findPath(DELETED_FIELD_NAME);
        return !deleted.isMissingNode() && deleted.booleanValue();
    }

    @Override
    public String getDoc() {
        return this.nodeAsString(this.node.findValue(DOC_FIELD_NAME));
    }

    @Override
    public JsonNode getDocAsNode() {
        return this.node.findPath(DOC_FIELD_NAME);
    }

    private String nodeAsString(JsonNode node) {
        if (this.isNull(node)) {
            return null;
        }
        return node.isContainerNode() ? node.toString() : node.asText();
    }

    private boolean isNull(JsonNode node) {
        return node == null || node.isNull() || node.isMissingNode();
    }

    @Override
    public String getRevision() {
        return this.nodeAsString(this.node.findValue(REV_FIELD_NAME));
    }

    @Override
    public List<String> getRevisions() {
        ArrayList<String> revisions = new ArrayList<String>();
        for (JsonNode changesNode : this.node.get(CHANGES_FIELD_NAME)) {
            revisions.add(this.nodeAsString(changesNode.get(REV_FIELD_NAME)));
        }
        return Collections.unmodifiableList(revisions);
    }

    public String toString() {
        return this.node.toString();
    }
}

