/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl.docref;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.ektorp.CouchDbConnector;
import org.ektorp.docref.DocumentReferences;
import org.ektorp.docref.FetchType;
import org.ektorp.impl.docref.ConstructibleAnnotatedCollection;
import org.ektorp.impl.docref.LazyLoadingViewBasedCollection;
import org.ektorp.impl.docref.ViewBasedCollection;
import org.ektorp.util.Documents;

public class BackReferencedBeanDeserializer
extends StdDeserializer<Object>
implements ResolvableDeserializer {
    private final CouchDbConnector couchDbConnector;
    private final BeanDeserializer delegate;
    private final List<ConstructibleAnnotatedCollection> backReferencedFields;
    private final Class<?> clazz;

    public BackReferencedBeanDeserializer(BeanDeserializer deserializer, List<ConstructibleAnnotatedCollection> fields, CouchDbConnector couchDbConnector, Class<?> clazz) {
        super(clazz);
        this.clazz = clazz;
        this.delegate = deserializer;
        this.couchDbConnector = couchDbConnector;
        this.backReferencedFields = fields;
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object deserializedObject = this.delegate.deserialize(jp, ctxt);
        this.addbackReferencedFields(deserializedObject, ctxt);
        return deserializedObject;
    }

    private void addbackReferencedFields(Object deserializedObject, DeserializationContext ctxt) throws IOException {
        String id = Documents.getId(deserializedObject);
        for (ConstructibleAnnotatedCollection constructibleField : this.backReferencedFields) {
            DocumentReferences ann = constructibleField.getField().getAnnotation(DocumentReferences.class);
            try {
                ViewBasedCollection handler;
                if (ann.fetch().equals((Object)FetchType.EAGER)) {
                    handler = new ViewBasedCollection(id, this.couchDbConnector, this.clazz, ann, constructibleField);
                    handler.initialize();
                } else {
                    handler = new LazyLoadingViewBasedCollection(id, this.couchDbConnector, this.clazz, ann, constructibleField);
                }
                Object o = Proxy.newProxyInstance(constructibleField.getCollectionType().getRawClass().getClassLoader(), new Class[]{constructibleField.getCollectionType().getRawClass()}, (InvocationHandler)handler);
                constructibleField.getSetter().set(deserializedObject, o);
            }
            catch (Exception e) {
                throw new IOException("Failed creating reflection proxy for collection " + constructibleField, e);
            }
        }
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt, Object intoValue) throws IOException, JsonProcessingException {
        Object deserializedObject = super.deserialize(jp, ctxt, intoValue);
        this.addbackReferencedFields(deserializedObject, ctxt);
        return deserializedObject;
    }

    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        this.delegate.resolve(ctxt);
    }
}

