/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl.docref;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.ektorp.BulkDeleteDocument;
import org.ektorp.ComplexKey;
import org.ektorp.CouchDbConnector;
import org.ektorp.DbAccessException;
import org.ektorp.ViewQuery;
import org.ektorp.docref.CascadeType;
import org.ektorp.docref.DocumentReferences;
import org.ektorp.impl.NameConventions;
import org.ektorp.impl.docref.ConstructibleAnnotatedCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewBasedCollection
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ViewBasedCollection.class);
    final String id;
    final CouchDbConnector couchDbConnector;
    final Class<?> clazz;
    final DocumentReferences referenceMetaData;
    final ConstructibleAnnotatedCollection constructibleAnnotatedCollection;
    final Collection<?> collection;
    private final Collection<BulkDeleteDocument> pendingRemoval = new LinkedHashSet<BulkDeleteDocument>();

    public ViewBasedCollection(String id, CouchDbConnector couchDbConnector, Class<?> clazz, DocumentReferences documentReferences, ConstructibleAnnotatedCollection constructibleField) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        this.id = id;
        this.couchDbConnector = couchDbConnector;
        this.clazz = clazz;
        this.referenceMetaData = documentReferences;
        this.constructibleAnnotatedCollection = constructibleField;
        this.collection = constructibleField.getConstructor().newInstance(new Object[0]);
    }

    private List<?> loadFromBackReferences(String thisId, DocumentReferences ann, CollectionType collectionType, String fieldName) throws JsonMappingException {
        try {
            Class raw = collectionType.getRawClass();
            if (Set.class.isAssignableFrom(raw)) {
                ViewQuery query = this.createBackReferenceQuery(thisId, ann, fieldName);
                Class klass = collectionType.getContentType().getRawClass();
                return this.loadSetResult(query, klass);
            }
            throw new DbAccessException("Unsupported back reference collection type: " + raw);
        }
        catch (DbAccessException e) {
            if (e.getCause() instanceof JsonProcessingException) {
                JsonProcessingException jpe = (JsonProcessingException)e.getCause();
                throw JsonMappingException.wrapWithPath((Throwable)jpe, (Object)new JsonMappingException.Reference((Object)collectionType.getContentType().getRawClass()), (String)fieldName);
            }
            throw e;
        }
    }

    private List<?> loadSetResult(ViewQuery query, Class<?> klass) {
        return this.couchDbConnector.queryView(query, klass);
    }

    private ViewQuery createBackReferenceQuery(String thisId, DocumentReferences ann, String fieldName) {
        boolean desc = ann.descendingSortOrder();
        ComplexKey start = ComplexKey.of(thisId, fieldName);
        ComplexKey end = ComplexKey.of(thisId, fieldName, ComplexKey.emptyObject());
        if (desc) {
            ComplexKey tmp = start;
            start = end;
            end = tmp;
        }
        return new ViewQuery().designDocId(this.resolveDesignDocId(ann)).viewName(this.resolveViewName(ann, fieldName)).includeDocs(true).descending(ann.descendingSortOrder()).startKey(start).endKey(end);
    }

    private String resolveViewName(DocumentReferences ann, String fieldName) {
        return ann.view().length() > 0 ? ann.view() : NameConventions.backReferenceViewName(fieldName);
    }

    private String resolveDesignDocId(DocumentReferences ann) {
        return ann.designDoc().length() > 0 ? ann.designDoc() : NameConventions.designDocName(this.clazz);
    }

    protected void initialize() throws IOException {
        List<?> list = this.loadFromBackReferences(this.id, this.referenceMetaData, this.constructibleAnnotatedCollection.getCollectionType(), this.constructibleAnnotatedCollection.getField().getName());
        this.collection.addAll(list);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("set")) {
            List list = (List)this.collection;
            this.addToPendingRemoval(list.get((Integer)args[1]));
        }
        if (method.getName().equals("remove")) {
            this.addToPendingRemoval(args[0]);
        }
        if (method.getName().equals("removeAll")) {
            this.addToPendingRemoval(args[0]);
        }
        if (method.getName().equals("retainAll")) {
            this.addToPendingRemoval(this.difference(this.collection, (Collection)args[0]));
        }
        if (method.getName().equals("iterator")) {
            return new RememberRemovedIterator();
        }
        if (method.getName().equals("listIterator")) {
            return new RememberRemovedListIterator();
        }
        return method.invoke(this.collection, args);
    }

    private Collection<? extends Object> difference(Collection<?> c1, Collection<?> c2) {
        ArrayList a1 = new ArrayList(c1);
        ArrayList b1 = new ArrayList(c1);
        ArrayList a2 = new ArrayList(c2);
        a1.retainAll(a2);
        b1.removeAll(a1);
        return b1;
    }

    public boolean initialized() {
        return true;
    }

    public Collection<BulkDeleteDocument> getPendingRemoval() {
        return this.pendingRemoval;
    }

    void addToPendingRemoval(Object o) {
        if (!this.cascadeDelete()) {
            return;
        }
        LOG.debug("adding {} to pending removal list", o);
        this.pendingRemoval.add(BulkDeleteDocument.of(o));
    }

    private boolean cascadeDelete() {
        for (CascadeType t : this.referenceMetaData.cascade()) {
            if (!CascadeType.DELETE_TYPES.contains((Object)t)) continue;
            return true;
        }
        return false;
    }

    public class RememberRemovedListIterator
    implements ListIterator<Object> {
        private final ListIterator<Object> it;
        private Object current;

        public RememberRemovedListIterator() {
            this.it = ((List)ViewBasedCollection.this.collection).listIterator();
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Object next() {
            this.current = this.it.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current != null) {
                ViewBasedCollection.this.addToPendingRemoval(this.current);
            }
            this.it.remove();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        @Override
        public Object previous() {
            this.current = this.it.previous();
            return this.current;
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex();
        }

        @Override
        public void set(Object e) {
            ViewBasedCollection.this.addToPendingRemoval(e);
            this.it.set(e);
        }

        @Override
        public void add(Object e) {
            this.it.add(e);
        }
    }

    public class RememberRemovedIterator
    implements Iterator<Object> {
        private final Iterator<?> it;
        private Object current;

        public RememberRemovedIterator() {
            this.it = ViewBasedCollection.this.collection.iterator();
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Object next() {
            this.current = this.it.next();
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current != null) {
                ViewBasedCollection.this.addToPendingRemoval(this.current);
            }
            this.it.remove();
        }
    }
}

