/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.ektorp.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Attachment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String contentType;
    private long length;
    private String dataBase64;
    private boolean stub;
    private int revpos;
    private String digest;
    private Map<String, Object> anonymous;

    public Attachment(String id, String data, String contentType) {
        Assert.hasText(id, "attachmentId must have a value");
        Assert.hasText(contentType, "contentType must have a value");
        Assert.notNull(data, "data input stream cannot be null");
        this.id = id;
        this.contentType = contentType;
        this.dataBase64 = data;
        this.length = data.getBytes().length;
    }

    Attachment() {
    }

    @JsonProperty(value="content_type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="content_type")
    void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonIgnore
    public long getContentLength() {
        return this.length;
    }

    @JsonProperty(value="data")
    public String getDataBase64() {
        return this.dataBase64;
    }

    @JsonIgnore
    public String getId() {
        return this.id;
    }

    @JsonIgnore
    void setId(String id) {
        this.id = id;
    }

    void setLength(long contentLength) {
        this.length = contentLength;
    }

    public boolean isStub() {
        return this.stub;
    }

    void setStub(boolean stub) {
        this.stub = stub;
    }

    public int getRevpos() {
        return this.revpos;
    }

    public void setRevpos(int revpos) {
        this.revpos = revpos;
    }

    public String getDigest() {
        return this.digest;
    }

    @JsonAnyGetter
    public Map<String, Object> getAnonymous() {
        return this.anonymous();
    }

    @JsonAnySetter
    public void setAnonymous(String key, Object value) {
        this.anonymous().put(key, value);
    }

    private Map<String, Object> anonymous() {
        if (this.anonymous == null) {
            this.anonymous = new HashMap<String, Object>();
        }
        return this.anonymous;
    }
}

