/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import com.fasterxml.jackson.databind.JsonNode;
import org.ektorp.DbAccessException;

public class DocumentNotFoundException
extends DbAccessException {
    private static final long serialVersionUID = -4130993962797968754L;
    private final String path;
    private final JsonNode body;

    public DocumentNotFoundException(String path, JsonNode responseBody) {
        super(String.format("nothing found on db path: %s, Response body: %s", path, responseBody));
        this.path = path;
        this.body = responseBody;
    }

    public DocumentNotFoundException(String path) {
        super(String.format("nothing found on db path: %s", path));
        this.path = path;
        this.body = null;
    }

    private boolean checkReason(String expect) {
        if (this.body == null) {
            return false;
        }
        JsonNode reason = this.body.findPath("reason");
        return !reason.isMissingNode() ? reason.textValue().equals(expect) : false;
    }

    public boolean isDocumentDeleted() {
        return this.checkReason("deleted");
    }

    public boolean isDatabaseDeleted() {
        return this.checkReason("no_db_file");
    }

    public JsonNode getBody() {
        return this.body;
    }

    public String getPath() {
        return this.path;
    }
}

