/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import java.util.Iterator;
import java.util.List;
import org.ektorp.PageRequest;

public class Page<T>
implements Iterable<T> {
    private final int totalSize;
    private final int pageSize;
    private final PageRequest previousPageRequest;
    private final PageRequest nextPageRequest;
    private final List<T> rows;

    public Page(List<T> rows, int totalSize, int pageSize, PageRequest previousPageRequest, PageRequest nextPageRequest) {
        this.rows = rows;
        this.totalSize = totalSize;
        this.pageSize = pageSize;
        this.previousPageRequest = previousPageRequest;
        this.nextPageRequest = nextPageRequest;
    }

    @Override
    public Iterator<T> iterator() {
        return this.rows.iterator();
    }

    public List<T> getRows() {
        return this.rows;
    }

    public boolean isHasNext() {
        return this.nextPageRequest != null;
    }

    public boolean isHasPrevious() {
        return this.previousPageRequest != null;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getNextLink() {
        if (!this.isHasNext()) {
            throw new IllegalStateException("Cannot create next link as no next page exists");
        }
        return this.nextPageRequest.asLink();
    }

    public PageRequest getNextPageRequest() {
        return this.nextPageRequest;
    }

    public PageRequest getPreviousPageRequest() {
        return this.previousPageRequest;
    }

    public String getPreviousLink() {
        if (!this.isHasPrevious()) {
            throw new IllegalStateException("Cannot create previous link as no previous page exists");
        }
        return this.previousPageRequest.asLink();
    }

    public int size() {
        return this.rows.size();
    }
}

