/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import org.ektorp.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ReplicationCommand
implements Serializable {
    private static final long serialVersionUID = 6919908757724780784L;
    @JsonProperty
    public final String source;
    @JsonProperty
    public final String target;
    @JsonProperty
    public final String proxy;
    @JsonProperty
    public final String filter;
    @JsonProperty(value="doc_ids")
    public final Collection<String> docIds;
    @JsonProperty
    public final Boolean continuous;
    @JsonProperty
    public final Boolean cancel;
    @JsonProperty(value="query_params")
    public final Object queryParams;
    @JsonProperty(value="create_target")
    public final Boolean createTarget;

    private ReplicationCommand(Builder b) {
        this.source = b.source;
        this.target = b.target;
        this.proxy = b.proxy;
        this.filter = b.filter;
        this.docIds = b.docIds;
        this.continuous = b.continuous ? Boolean.TRUE : null;
        this.cancel = b.cancel ? Boolean.TRUE : null;
        this.createTarget = b.createTarget ? Boolean.TRUE : null;
        this.queryParams = b.queryParams;
    }

    public static class Builder {
        private String source;
        private String target;
        private String proxy;
        private String filter;
        private Collection<String> docIds;
        private boolean continuous;
        private boolean cancel;
        private boolean createTarget;
        private Object queryParams;

        public Builder source(String s) {
            this.source = s;
            return this;
        }

        public Builder target(String s) {
            this.target = s;
            return this;
        }

        public Builder proxy(String s) {
            this.proxy = s;
            return this;
        }

        public Builder filter(String s) {
            this.filter = s;
            return this;
        }

        public Builder docIds(Collection<String> docIds) {
            this.docIds = docIds;
            return this;
        }

        public Builder continuous(boolean b) {
            this.continuous = b;
            return this;
        }

        public Builder cancel(boolean b) {
            this.cancel = b;
            return this;
        }

        public Builder queryParams(Object o) {
            this.queryParams = o;
            return this;
        }

        public Builder createTarget(boolean b) {
            this.createTarget = b;
            return this;
        }

        public ReplicationCommand build() {
            Assert.hasText(this.source, "source may not be null or empty");
            Assert.hasText(this.target, "target may not be null or empty");
            return new ReplicationCommand(this);
        }
    }
}

