/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import org.ektorp.util.Assert;

public class Revision
implements Serializable {
    private static final long serialVersionUID = -1740321573214780237L;
    private final String rev;
    private final String status;

    @JsonCreator
    public Revision(@JsonProperty(value="rev") String rev, @JsonProperty(value="status") String status) {
        Assert.hasText(rev, "revision cannot be empty");
        Assert.hasText(status, "status cannot be empty");
        this.rev = rev;
        this.status = status;
    }

    public String getRev() {
        return this.rev;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isMissing() {
        return "missing".equals(this.status);
    }

    public boolean isOnDisk() {
        return "disk".equals(this.status);
    }

    public boolean isDeleted() {
        return "deleted".equals(this.status);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Revision) {
            Revision r = (Revision)o;
            return this.rev.equals(r.rev);
        }
        return false;
    }

    public int hashCode() {
        return this.rev.hashCode();
    }
}

