/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ektorp.ViewResultException;
import org.ektorp.util.Assert;

public class ViewResult
implements Iterable<Row>,
Serializable {
    private static final String OFFSET_FIELD_NAME = "offset";
    private static final String TOTAL_ROWS_FIELD_NAME = "total_rows";
    private static final String UPDATE_SEQ = "update_seq";
    private static final long serialVersionUID = 4750290767933801714L;
    private int totalRows = -1;
    private int offset = -1;
    private String updateSeq;
    private List<Row> rows;

    public ViewResult(JsonNode resultNode, boolean ignoreNotFound) {
        Assert.notNull(resultNode, "resultNode may not be null");
        Assert.isTrue(resultNode.findPath("rows").isArray(), "result must contain 'rows' field of array type");
        if (resultNode.get(TOTAL_ROWS_FIELD_NAME) != null) {
            this.totalRows = resultNode.get(TOTAL_ROWS_FIELD_NAME).intValue();
        }
        if (resultNode.get(OFFSET_FIELD_NAME) != null) {
            this.offset = resultNode.get(OFFSET_FIELD_NAME).intValue();
        }
        if (resultNode.get(UPDATE_SEQ) != null) {
            this.updateSeq = resultNode.get(UPDATE_SEQ).textValue();
            if (this.updateSeq == null) {
                this.updateSeq = Long.toString(resultNode.get(UPDATE_SEQ).intValue());
            }
        }
        JsonNode rowsNode = resultNode.get("rows");
        this.rows = new ArrayList<Row>(rowsNode.size());
        for (JsonNode n : rowsNode) {
            if (ignoreNotFound && n.has("error")) continue;
            this.rows.add(new Row(n));
        }
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public int getSize() {
        return this.rows.size();
    }

    public int getOffset() {
        return this.offset;
    }

    @JsonProperty
    void setOffset(int offset) {
        this.offset = offset;
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    @JsonProperty(value="total_rows")
    void setTotalRows(int i) {
        this.totalRows = i;
    }

    public long getUpdateSeq() {
        if (this.updateSeq != null) {
            return Long.parseLong(this.updateSeq);
        }
        return -1L;
    }

    public boolean isUpdateSeqNumeric() {
        return this.updateSeq != null && this.updateSeq.matches("^\\d*$");
    }

    public String getUpdateSeqAsString() {
        return this.updateSeq;
    }

    @JsonProperty(value="update_seq")
    public void setUpdateSeq(String updateSeq) {
        this.updateSeq = updateSeq;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.rows.iterator();
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{\n\"total_rows\":");
        builder.append(this.totalRows);
        builder.append(",\n\"offset\":");
        builder.append(this.offset);
        builder.append(",\n\"rows\":");
        builder.append(this.rows.toString());
        builder.append("\n}");
        return builder.toString();
    }

    public static class Row {
        static final String VALUE_FIELD_NAME = "value";
        static final String ID_FIELD_NAME = "id";
        static final String KEY_FIELD_NAME = "key";
        static final String DOC_FIELD_NAME = "doc";
        static final String ERROR_FIELD_NAME = "error";
        private final JsonNode rowNode;

        @JsonCreator
        public Row(JsonNode rowNode) {
            Assert.notNull(rowNode, "row node may not be null");
            this.rowNode = rowNode;
            if (this.getError() != null) {
                throw new ViewResultException(this.getKeyAsNode(), this.getError());
            }
        }

        public String getId() {
            return this.rowNode.get(ID_FIELD_NAME).textValue();
        }

        public String getKey() {
            return this.nodeAsString(this.getKeyAsNode());
        }

        public JsonNode getKeyAsNode() {
            return this.rowNode.findPath(KEY_FIELD_NAME);
        }

        public String getValue() {
            return this.nodeAsString(this.getValueAsNode());
        }

        public int getValueAsInt() {
            return this.getValueAsNode().asInt(0);
        }

        public JsonNode getValueAsNode() {
            return this.rowNode.findPath(VALUE_FIELD_NAME);
        }

        public String getDoc() {
            return this.nodeAsString(this.rowNode.findValue(DOC_FIELD_NAME));
        }

        public JsonNode getDocAsNode() {
            return this.rowNode.findPath(DOC_FIELD_NAME);
        }

        private String getError() {
            return this.nodeAsString(this.rowNode.get(ERROR_FIELD_NAME));
        }

        private String nodeAsString(JsonNode node) {
            if (this.isNull(node)) {
                return null;
            }
            return node.isContainerNode() ? node.toString() : node.asText();
        }

        private boolean isNull(JsonNode node) {
            return node == null || node.isNull() || node.isMissingNode();
        }

        public String toString() {
            return this.rowNode.toString();
        }
    }
}

