/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.ektorp.ActiveTask;
import org.ektorp.CouchDbConnector;
import org.ektorp.CouchDbInstance;
import org.ektorp.DbAccessException;
import org.ektorp.DbPath;
import org.ektorp.ReplicationCommand;
import org.ektorp.ReplicationStatus;
import org.ektorp.http.HttpClient;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.RestTemplate;
import org.ektorp.http.StdResponseHandler;
import org.ektorp.impl.JsonSerializer;
import org.ektorp.impl.ObjectMapperFactory;
import org.ektorp.impl.StdActiveTask;
import org.ektorp.impl.StdCouchDbConnector;
import org.ektorp.impl.StdObjectMapperFactory;
import org.ektorp.impl.StreamingJsonSerializer;
import org.ektorp.util.Assert;
import org.ektorp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdCouchDbInstance
implements CouchDbInstance {
    private static final Logger LOG = LoggerFactory.getLogger(StdCouchDbInstance.class);
    private static final TypeReference<List<String>> STRING_LIST_TYPE_DEF = new TypeReference<List<String>>(){};
    private final HttpClient client;
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;
    private final ObjectMapperFactory objectMapperFactory;
    private JsonSerializer jsonSerializer;

    public StdCouchDbInstance(HttpClient client) {
        this(client, new StdObjectMapperFactory());
    }

    public StdCouchDbInstance(HttpClient client, ObjectMapperFactory of) {
        Assert.notNull(client, "HttpClient may not be null");
        Assert.notNull(of, "ObjectMapperFactory may not be null");
        this.client = client;
        this.restTemplate = new RestTemplate(client);
        this.objectMapper = of.createObjectMapper();
        this.jsonSerializer = new StreamingJsonSerializer(this.objectMapper);
        this.objectMapperFactory = of;
    }

    @Override
    public void createDatabase(String path) {
        this.createDatabase(DbPath.fromString(path));
    }

    @Override
    public void createDatabase(DbPath db) {
        if (this.checkIfDbExists(db)) {
            throw new DbAccessException(String.format("A database with path %s already exists", db.getPath()));
        }
        LOG.debug("creating db path: {}", (Object)db.getPath());
        this.restTemplate.put(db.getPath());
    }

    @Override
    public void deleteDatabase(String path) {
        Assert.notNull(path);
        this.restTemplate.delete(DbPath.fromString(path).getPath());
    }

    @Override
    public boolean checkIfDbExists(String path) {
        return this.checkIfDbExists(DbPath.fromString(path));
    }

    @Override
    public boolean checkIfDbExists(DbPath db) {
        return this.restTemplate.head(db.getPath(), new StdResponseHandler<Boolean>(){

            @Override
            public Boolean error(HttpResponse hr) {
                return false;
            }

            @Override
            public Boolean success(HttpResponse hr) throws Exception {
                return true;
            }
        });
    }

    @Override
    public List<String> getAllDatabases() {
        return this.restTemplate.get("/_all_dbs", new StdResponseHandler<List<String>>(){

            @Override
            public List<String> success(HttpResponse hr) throws Exception {
                return (List)StdCouchDbInstance.this.objectMapper.readValue(hr.getContent(), STRING_LIST_TYPE_DEF);
            }
        });
    }

    @Override
    public ReplicationStatus replicate(ReplicationCommand cmd) {
        try {
            return this.restTemplate.post("/_replicate", this.objectMapper.writeValueAsString((Object)cmd), new StdResponseHandler<ReplicationStatus>(){

                @Override
                public ReplicationStatus success(HttpResponse hr) throws Exception {
                    return (ReplicationStatus)StdCouchDbInstance.this.objectMapper.readValue(hr.getContent(), ReplicationStatus.class);
                }
            });
        }
        catch (IOException e) {
            throw Exceptions.propagate(e);
        }
    }

    @Override
    public HttpClient getConnection() {
        return this.client;
    }

    @Override
    public CouchDbConnector createConnector(String path, boolean createIfNotExists) {
        StdCouchDbConnector db = new StdCouchDbConnector(path, this, this.objectMapperFactory);
        if (createIfNotExists) {
            db.createDatabaseIfNotExists();
        }
        return db;
    }

    @Override
    public CouchDbConnector getReplicatorConnector() {
        return this.createConnector("_replicator", false);
    }

    @Override
    public <T> T getConfiguration(Class<T> c) {
        return this.getConfiguration(c, null, null);
    }

    @Override
    public <T> T getConfiguration(Class<T> c, String section) {
        return this.getConfiguration(c, section, null);
    }

    @Override
    public <T> T getConfiguration(final Class<T> c, String section, String key) {
        Assert.notNull(c, "Class may not be null");
        String url = "/_config";
        if (section != null) {
            url = url + "/" + section;
            if (key != null) {
                url = url + "/" + key;
            }
        }
        return this.restTemplate.get(url, new StdResponseHandler<T>(){

            @Override
            public T success(HttpResponse hr) throws Exception {
                return StdCouchDbInstance.this.objectMapper.readValue(hr.getContent(), c);
            }
        });
    }

    @Override
    public String getConfiguration(String section, String key) {
        return this.getConfiguration(String.class, section, key);
    }

    @Override
    public String setConfiguration(String section, String key, String value) {
        Assert.notNull(section, "Section may not be null");
        Assert.notNull(key, "Key may not be null");
        String url = "/_config/" + section + "/" + key;
        return this.restTemplate.put(url, this.jsonSerializer.toJson(value), new StdResponseHandler<String>(){

            @Override
            public String success(HttpResponse hr) throws Exception {
                return (String)StdCouchDbInstance.this.objectMapper.readValue(hr.getContent(), String.class);
            }
        });
    }

    @Override
    public String deleteConfiguration(String section, String key) {
        Assert.notNull(section, "Section may not be null");
        Assert.notNull(key, "Key may not be null");
        String url = "/_config/" + section + "/" + key;
        return this.restTemplate.delete(url, new StdResponseHandler<String>(){

            @Override
            public String success(HttpResponse hr) throws Exception {
                return (String)StdCouchDbInstance.this.objectMapper.readValue(hr.getContent(), String.class);
            }
        });
    }

    @Override
    public Collection<ActiveTask> getActiveTasks() {
        String url = "/_active_tasks";
        List<StdActiveTask> tasks = this.restTemplate.get(url, new StdResponseHandler<List<StdActiveTask>>(){

            @Override
            public List<StdActiveTask> success(HttpResponse hr) throws Exception {
                return (List)StdCouchDbInstance.this.objectMapper.readValue(hr.getContent(), (TypeReference)new TypeReference<List<StdActiveTask>>(){});
            }
        });
        ArrayList<ActiveTask> ret = new ArrayList<ActiveTask>();
        for (StdActiveTask task : tasks) {
            ret.add(task);
        }
        return ret;
    }
}

