/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.ektorp.CouchDbConnector;
import org.ektorp.impl.ObjectMapperFactory;
import org.ektorp.impl.jackson.EktorpJacksonModule;
import org.ektorp.util.Assert;

public class StdObjectMapperFactory
implements ObjectMapperFactory {
    private ObjectMapper instance;
    private boolean writeDatesAsTimestamps = false;

    @Override
    public synchronized ObjectMapper createObjectMapper() {
        if (this.instance == null) {
            this.instance = new ObjectMapper();
            this.applyDefaultConfiguration(this.instance);
        }
        return this.instance;
    }

    @Override
    public ObjectMapper createObjectMapper(CouchDbConnector connector) {
        ObjectMapper objectMapper = new ObjectMapper();
        this.applyDefaultConfiguration(objectMapper);
        objectMapper.registerModule((Module)new EktorpJacksonModule(connector, objectMapper));
        return objectMapper;
    }

    public synchronized void setObjectMapper(ObjectMapper om) {
        Assert.notNull(om, "ObjectMapper may not be null");
        this.instance = om;
    }

    public void setWriteDatesAsTimestamps(boolean b) {
        this.writeDatesAsTimestamps = b;
    }

    private void applyDefaultConfiguration(ObjectMapper om) {
        om.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, this.writeDatesAsTimestamps);
        om.getSerializationConfig().withSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

