/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ektorp.http.URI;
import org.ektorp.impl.StdObjectMapperFactory;
import org.ektorp.util.Assert;
import org.ektorp.util.Exceptions;

public class ViewQuery {
    private static final ObjectMapper DEFAULT_MAPPER = new StdObjectMapperFactory().createObjectMapper();
    private static final String ALL_DOCS_VIEW_NAME = "_all_docs";
    private static final int NOT_SET = -1;
    private final Map<String, String> queryParams = new TreeMap<String, String>();
    private ObjectMapper mapper;
    private String dbPath;
    private String designDocId;
    private String viewName;
    private Object key;
    private Keys keys;
    private Object startKey;
    private String startDocId;
    private Object endKey;
    private String endDocId;
    private int limit = -1;
    private String staleOk;
    private boolean descending;
    private int skip = -1;
    private boolean group;
    private int groupLevel = -1;
    private boolean reduce = true;
    private boolean includeDocs = false;
    private boolean inclusiveEnd = true;
    private boolean ignoreNotFound = false;
    private boolean updateSeq = false;
    private boolean cacheOk = false;
    private String cachedQuery;
    private String listName;

    public ViewQuery() {
        this.mapper = DEFAULT_MAPPER;
    }

    public ViewQuery(ObjectMapper om) {
        Assert.notNull(om, "ObjectMapper may not be null");
        this.mapper = om;
    }

    public String getDbPath() {
        return this.dbPath;
    }

    public String getDesignDocId() {
        return this.designDocId;
    }

    public String getViewName() {
        return this.viewName;
    }

    public String getStartDocId() {
        return this.startDocId;
    }

    public String getEndDocId() {
        return this.endDocId;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isStaleOk() {
        return this.staleOk != null && ("ok".equals(this.staleOk) || "update_after".equals(this.staleOk));
    }

    public boolean isDescending() {
        return this.descending;
    }

    public int getSkip() {
        return this.skip;
    }

    public boolean isGroup() {
        return this.group;
    }

    public int getGroupLevel() {
        return this.groupLevel;
    }

    public boolean isReduce() {
        return this.reduce;
    }

    public boolean isIncludeDocs() {
        return this.includeDocs;
    }

    public boolean isInclusiveEnd() {
        return this.inclusiveEnd;
    }

    public boolean isUpdateSeq() {
        return this.updateSeq;
    }

    public ViewQuery dbPath(String s) {
        this.reset();
        this.dbPath = s;
        return this;
    }

    public ViewQuery designDocId(String s) {
        this.reset();
        this.designDocId = s;
        return this;
    }

    public ViewQuery allDocs() {
        this.reset();
        this.viewName = ALL_DOCS_VIEW_NAME;
        return this;
    }

    public ViewQuery viewName(String s) {
        this.reset();
        this.viewName = s;
        return this;
    }

    public ViewQuery listName(String s) {
        this.reset();
        this.listName = s;
        return this;
    }

    public ViewQuery cacheOk(boolean b) {
        this.reset();
        this.cacheOk = b;
        return this;
    }

    public boolean isCacheOk() {
        return this.cacheOk;
    }

    public ViewQuery key(String s) {
        this.reset();
        this.key = s;
        return this;
    }

    public ViewQuery rawKey(String s) {
        this.reset();
        this.key = this.parseJson(s);
        return this;
    }

    private JsonNode parseJson(String s) {
        try {
            return this.mapper.readTree(s);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    public ViewQuery key(int i) {
        this.reset();
        this.key = i;
        return this;
    }

    public ViewQuery key(long l) {
        this.reset();
        this.key = l;
        return this;
    }

    public ViewQuery key(float f) {
        this.reset();
        this.key = Float.valueOf(f);
        return this;
    }

    public ViewQuery key(double d) {
        this.reset();
        this.key = d;
        return this;
    }

    public ViewQuery key(boolean b) {
        this.reset();
        this.key = b;
        return this;
    }

    public ViewQuery key(Object o) {
        this.reset();
        this.key = o;
        return this;
    }

    public ViewQuery keys(Collection<?> keyList) {
        this.reset();
        this.keys = Keys.of(keyList);
        return this;
    }

    public Keys getKeys() {
        return this.keys;
    }

    public Collection<?> getKeysValues() {
        return this.keys.getValues();
    }

    public ViewQuery startKey(String s) {
        this.reset();
        this.startKey = s;
        return this;
    }

    public ViewQuery rawStartKey(String s) {
        this.reset();
        this.startKey = this.parseJson(s);
        return this;
    }

    public ViewQuery startKey(int i) {
        this.reset();
        this.startKey = i;
        return this;
    }

    public ViewQuery startKey(long l) {
        this.reset();
        this.startKey = l;
        return this;
    }

    public ViewQuery startKey(float f) {
        this.reset();
        this.startKey = Float.valueOf(f);
        return this;
    }

    public ViewQuery startKey(double d) {
        this.reset();
        this.startKey = d;
        return this;
    }

    public ViewQuery startKey(boolean b) {
        this.reset();
        this.startKey = b;
        return this;
    }

    public ViewQuery startKey(Object o) {
        this.reset();
        this.startKey = o;
        return this;
    }

    public ViewQuery startDocId(String s) {
        this.reset();
        this.startDocId = s;
        return this;
    }

    public ViewQuery endKey(String s) {
        this.reset();
        this.endKey = s;
        return this;
    }

    public ViewQuery rawEndKey(String s) {
        this.reset();
        this.endKey = this.parseJson(s);
        return this;
    }

    public ViewQuery endKey(int i) {
        this.reset();
        this.endKey = i;
        return this;
    }

    public ViewQuery endKey(long l) {
        this.reset();
        this.endKey = l;
        return this;
    }

    public ViewQuery endKey(float f) {
        this.reset();
        this.endKey = Float.valueOf(f);
        return this;
    }

    public ViewQuery endKey(double d) {
        this.reset();
        this.endKey = d;
        return this;
    }

    public ViewQuery endKey(boolean b) {
        this.reset();
        this.endKey = b;
        return this;
    }

    public ViewQuery endKey(Object o) {
        this.reset();
        this.endKey = o;
        return this;
    }

    public ViewQuery endDocId(String s) {
        this.reset();
        this.endDocId = s;
        return this;
    }

    public ViewQuery limit(int i) {
        this.reset();
        this.limit = i;
        return this;
    }

    public ViewQuery staleOk(boolean b) {
        this.reset();
        this.staleOk = b ? "ok" : null;
        return this;
    }

    public ViewQuery staleOkUpdateAfter() {
        this.reset();
        this.staleOk = "update_after";
        return this;
    }

    public ViewQuery descending(boolean b) {
        this.reset();
        this.descending = b;
        return this;
    }

    public ViewQuery skip(int i) {
        this.reset();
        this.skip = i;
        return this;
    }

    public ViewQuery group(boolean b) {
        this.reset();
        this.group = b;
        return this;
    }

    public ViewQuery groupLevel(int i) {
        this.reset();
        this.groupLevel = i;
        return this;
    }

    public ViewQuery reduce(boolean b) {
        this.reset();
        this.reduce = b;
        return this;
    }

    public ViewQuery includeDocs(boolean b) {
        this.reset();
        this.includeDocs = b;
        return this;
    }

    public ViewQuery inclusiveEnd(boolean b) {
        this.reset();
        this.inclusiveEnd = b;
        return this;
    }

    public ViewQuery updateSeq(boolean b) {
        this.reset();
        this.updateSeq = b;
        return this;
    }

    public ViewQuery queryParam(String name, String value) {
        this.queryParams.put(name, value);
        return this;
    }

    public void reset() {
        this.cachedQuery = null;
    }

    public Object getKey() {
        return this.key;
    }

    public boolean hasMultipleKeys() {
        return this.keys != null;
    }

    public String getKeysAsJson() {
        if (this.keys == null) {
            return "{\"keys\":[]}";
        }
        return this.keys.toJson(this.mapper);
    }

    public Object getStartKey() {
        return this.startKey;
    }

    public Object getEndKey() {
        return this.endKey;
    }

    public String buildQuery() {
        if (this.cachedQuery != null) {
            return this.cachedQuery;
        }
        URI query = this.buildQueryURI();
        this.cachedQuery = query.toString();
        return this.cachedQuery;
    }

    public URI buildQueryURI() {
        URI query = this.buildViewPath();
        if (this.isNotEmpty(this.key)) {
            query.param("key", this.jsonEncode(this.key));
        }
        if (this.isNotEmpty(this.startKey)) {
            query.param("startkey", this.jsonEncode(this.startKey));
        }
        if (this.isNotEmpty(this.endKey)) {
            query.param("endkey", this.jsonEncode(this.endKey));
        }
        if (this.isNotEmpty(this.startDocId)) {
            query.param("startkey_docid", this.startDocId);
        }
        if (this.isNotEmpty(this.endDocId)) {
            query.param("endkey_docid", this.endDocId);
        }
        if (this.hasValue(this.limit)) {
            query.param("limit", this.limit);
        }
        if (this.staleOk != null) {
            query.param("stale", this.staleOk);
        }
        if (this.descending) {
            query.param("descending", "true");
        }
        if (!this.inclusiveEnd) {
            query.param("inclusive_end", "false");
        }
        if (!this.reduce) {
            query.param("reduce", "false");
        }
        if (this.hasValue(this.skip)) {
            query.param("skip", this.skip);
        }
        if (this.includeDocs) {
            query.param("include_docs", "true");
        }
        if (this.group) {
            query.param("group", "true");
        }
        if (this.hasValue(this.groupLevel)) {
            query.param("group_level", this.groupLevel);
        }
        if (!this.queryParams.isEmpty()) {
            this.appendQueryParams(query);
        }
        if (this.updateSeq) {
            query.param("update_seq", "true");
        }
        return query;
    }

    @SuppressWarnings(value={"SA_FIELD_SELF_ASSIGNMENT", "CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE"})
    public ViewQuery clone() {
        ViewQuery copy = new ViewQuery();
        copy.mapper = this.mapper;
        copy.cacheOk = this.cacheOk;
        copy.dbPath = this.dbPath;
        copy.descending = this.descending;
        copy.designDocId = this.designDocId;
        copy.endDocId = this.endDocId;
        copy.endKey = this.endKey;
        copy.group = this.group;
        copy.groupLevel = this.groupLevel;
        copy.ignoreNotFound = this.ignoreNotFound;
        copy.includeDocs = this.includeDocs;
        copy.inclusiveEnd = this.inclusiveEnd;
        copy.key = this.key;
        if (this.keys != null) {
            copy.keys = this.keys.clone();
        }
        copy.limit = this.limit;
        copy.listName = this.listName;
        copy.queryParams.putAll(this.queryParams);
        copy.reduce = this.reduce;
        copy.skip = copy.skip;
        copy.staleOk = this.staleOk;
        copy.startDocId = this.startDocId;
        copy.startKey = this.startKey;
        copy.updateSeq = this.updateSeq;
        copy.viewName = this.viewName;
        return copy;
    }

    private String jsonEncode(Object key) {
        try {
            return this.mapper.writeValueAsString(key);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    private void appendQueryParams(URI query) {
        for (Map.Entry<String, String> param : this.queryParams.entrySet()) {
            query.param(param.getKey(), param.getValue());
        }
    }

    private URI buildViewPath() {
        this.assertHasText(this.dbPath, "dbPath");
        this.assertHasText(this.viewName, "viewName");
        URI uri = URI.of(this.dbPath);
        if (this.isNotEmpty(this.listName)) {
            uri.append(this.designDocId).append("_list").append(this.listName).append(this.viewName);
        } else if (ALL_DOCS_VIEW_NAME.equals(this.viewName)) {
            uri.append(this.viewName);
        } else {
            this.assertHasText(this.designDocId, "designDocId");
            uri.append(this.designDocId).append("_view").append(this.viewName);
        }
        return uri;
    }

    private void assertHasText(String s, String fieldName) {
        if (s == null || s.length() == 0) {
            throw new IllegalStateException(String.format("%s must have a value", fieldName));
        }
    }

    private boolean hasValue(int i) {
        return i != -1;
    }

    private boolean isNotEmpty(Object s) {
        return s != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cachedQuery == null ? 0 : this.cachedQuery.hashCode());
        result = 31 * result + (this.dbPath == null ? 0 : this.dbPath.hashCode());
        result = 31 * result + (this.descending ? 1231 : 1237);
        result = 31 * result + (this.designDocId == null ? 0 : this.designDocId.hashCode());
        result = 31 * result + (this.endDocId == null ? 0 : this.endDocId.hashCode());
        result = 31 * result + (this.endKey == null ? 0 : this.endKey.hashCode());
        result = 31 * result + (this.group ? 1231 : 1237);
        result = 31 * result + this.groupLevel;
        result = 31 * result + (this.ignoreNotFound ? 1231 : 1237);
        result = 31 * result + (this.includeDocs ? 1231 : 1237);
        result = 31 * result + (this.inclusiveEnd ? 1231 : 1237);
        result = 31 * result + (this.updateSeq ? 1231 : 1237);
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + this.limit;
        result = 31 * result + (this.listName == null ? 0 : this.listName.hashCode());
        result = 31 * result + (this.queryParams == null ? 0 : this.queryParams.hashCode());
        result = 31 * result + (this.reduce ? 1231 : 1237);
        result = 31 * result + this.skip;
        result = 31 * result + (this.staleOk == null ? 0 : this.staleOk.hashCode());
        result = 31 * result + (this.startDocId == null ? 0 : this.startDocId.hashCode());
        result = 31 * result + (this.startKey == null ? 0 : this.startKey.hashCode());
        result = 31 * result + (this.viewName == null ? 0 : this.viewName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ViewQuery other = (ViewQuery)obj;
        if (this.cachedQuery == null ? other.cachedQuery != null : !this.cachedQuery.equals(other.cachedQuery)) {
            return false;
        }
        if (this.dbPath == null ? other.dbPath != null : !this.dbPath.equals(other.dbPath)) {
            return false;
        }
        if (this.descending != other.descending) {
            return false;
        }
        if (this.designDocId == null ? other.designDocId != null : !this.designDocId.equals(other.designDocId)) {
            return false;
        }
        if (this.endDocId == null ? other.endDocId != null : !this.endDocId.equals(other.endDocId)) {
            return false;
        }
        if (this.endKey == null ? other.endKey != null : !this.endKey.equals(other.endKey)) {
            return false;
        }
        if (this.group != other.group) {
            return false;
        }
        if (this.groupLevel != other.groupLevel) {
            return false;
        }
        if (this.ignoreNotFound != other.ignoreNotFound) {
            return false;
        }
        if (this.includeDocs != other.includeDocs) {
            return false;
        }
        if (this.inclusiveEnd != other.inclusiveEnd) {
            return false;
        }
        if (this.updateSeq != other.updateSeq) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.limit != other.limit) {
            return false;
        }
        if (this.listName == null ? other.listName != null : !this.listName.equals(other.listName)) {
            return false;
        }
        if (this.queryParams == null ? other.queryParams != null : !this.queryParams.equals(other.queryParams)) {
            return false;
        }
        if (this.reduce != other.reduce) {
            return false;
        }
        if (this.skip != other.skip) {
            return false;
        }
        if (this.staleOk == null ? other.staleOk != null : !this.staleOk.equals(other.staleOk)) {
            return false;
        }
        if (this.startDocId == null ? other.startDocId != null : !this.startDocId.equals(other.startDocId)) {
            return false;
        }
        if (this.startKey == null ? other.startKey != null : !this.startKey.equals(other.startKey)) {
            return false;
        }
        return !(this.viewName == null ? other.viewName != null : !this.viewName.equals(other.viewName));
    }

    public void setIgnoreNotFound(boolean ignoreNotFound) {
        this.ignoreNotFound = ignoreNotFound;
    }

    public boolean isIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    public String toString() {
        return this.buildQuery();
    }

    public static class Keys {
        private final List<?> keys;

        public static Keys of(Collection<?> keys) {
            return new Keys(keys.toArray());
        }

        public static Keys of(Object ... keys) {
            return new Keys(keys);
        }

        private Keys(Collection<?> keys) {
            this.keys = new ArrayList(keys);
        }

        private Keys(Object[] keys) {
            this.keys = Arrays.asList(keys);
        }

        public List<?> getValues() {
            return Collections.unmodifiableList(this.keys);
        }

        @SuppressWarnings(value={"CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE"})
        public Keys clone() {
            return new Keys(this.keys);
        }

        public String toJson() {
            return this.toJson(DEFAULT_MAPPER);
        }

        public String toJson(ObjectMapper mapper) {
            ObjectNode rootNode = mapper.createObjectNode();
            ArrayNode keysNode = rootNode.putArray("keys");
            for (Object key : this.keys) {
                keysNode.addPOJO(key);
            }
            try {
                return mapper.writeValueAsString((Object)rootNode);
            }
            catch (Exception e) {
                throw Exceptions.propagate(e);
            }
        }
    }
}

