/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.http.entity.AbstractHttpEntity;

public class InputStreamBulkEntity
extends AbstractHttpEntity {
    private static final byte[] BULK_HEADER_TRUE = "{\"all_or_nothing\":true,\"docs\":".getBytes(Charset.forName("UTF-8"));
    private static final byte[] BULK_HEADER_FALSE = "{\"all_or_nothing\":false,\"docs\":".getBytes(Charset.forName("UTF-8"));
    private static final byte[] BULK_FOOTER = "}".getBytes(Charset.forName("UTF-8"));
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private final InputStream inputStream;
    private final boolean allOrNothing;

    public InputStreamBulkEntity(InputStream inputStream, boolean allOrNothing) {
        this.inputStream = inputStream;
        this.allOrNothing = allOrNothing;
        this.setContentType("application/json");
    }

    public boolean isRepeatable() {
        return false;
    }

    public long getContentLength() {
        return -1L;
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        int l;
        if (this.allOrNothing) {
            outputStream.write(BULK_HEADER_TRUE);
        } else {
            outputStream.write(BULK_HEADER_FALSE);
        }
        byte[] buffer = new byte[2048];
        while ((l = this.inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, l);
        }
        outputStream.write(BULK_FOOTER);
    }

    public boolean isStreaming() {
        return true;
    }
}

