/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ektorp.DocumentOperationResult;
import org.ektorp.LocalBulkBuffer;
import org.ektorp.impl.BulkExecutor;
import org.ektorp.impl.ThreadLocalBulkBufferHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultLocalBulkBuffer
implements LocalBulkBuffer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLocalBulkBuffer.class);
    private final ThreadLocalBulkBufferHolder bulkBufferManager = new ThreadLocalBulkBufferHolder();
    private boolean allOrNothing = false;

    @Override
    public void addToBulkBuffer(Object o) {
        this.bulkBufferManager.add(o);
        LOG.debug("{} added to bulk buffer", o);
    }

    @Override
    public void clearBulkBuffer() {
        this.bulkBufferManager.clear();
        LOG.debug("bulk buffer cleared");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DocumentOperationResult> flushBulkBuffer() {
        try {
            List<Object> buffer = this.bulkBufferManager.getCurrentBuffer();
            if (buffer != null && !buffer.isEmpty()) {
                LOG.debug("flushing bulk buffer");
                List<DocumentOperationResult> list = this.getBulkExecutor().executeBulk(buffer, this.isAllOrNothing());
                return list;
            }
            LOG.debug("bulk buffer was empty");
            List<DocumentOperationResult> list = Collections.emptyList();
            return list;
        }
        finally {
            this.clearBulkBuffer();
        }
    }

    protected abstract BulkExecutor<Collection<?>> getBulkExecutor();

    public boolean isAllOrNothing() {
        return this.allOrNothing;
    }

    public void setAllOrNothing(boolean allOrNothing) {
        this.allOrNothing = allOrNothing;
    }
}

