/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import org.ektorp.ViewQuery;
import org.ektorp.http.ResponseCallback;
import org.ektorp.http.RestTemplate;
import org.ektorp.impl.QueryExecutor;
import org.ektorp.impl.StdCouchDbConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultQueryExecutor
implements QueryExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(StdCouchDbConnector.class);
    private RestTemplate restTemplate;

    public DefaultQueryExecutor() {
    }

    public DefaultQueryExecutor(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate value) {
        this.restTemplate = value;
    }

    @Override
    public <T> T executeQuery(ViewQuery query, ResponseCallback<T> rh) {
        LOG.debug("Querying CouchDb view at {}.", (Object)query);
        T result = !query.isCacheOk() ? (query.hasMultipleKeys() ? this.getRestTemplate().postUncached(query.buildQuery(), query.getKeysAsJson(), rh) : this.getRestTemplate().getUncached(query.buildQuery(), rh)) : (query.hasMultipleKeys() ? this.getRestTemplate().post(query.buildQuery(), query.getKeysAsJson(), rh) : this.getRestTemplate().get(query.buildQuery(), rh));
        LOG.debug("Answer from view query: {}.", result);
        return result;
    }
}

