/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import org.apache.http.HttpEntity;
import org.ektorp.DocumentOperationResult;
import org.ektorp.http.JacksonableEntity;
import org.ektorp.http.RestTemplate;
import org.ektorp.http.URI;
import org.ektorp.impl.BulkDocumentBean;
import org.ektorp.impl.BulkExecutor;
import org.ektorp.impl.BulkOperationResponseHandler;

public class EntityCollectionBulkExecutor
implements BulkExecutor<Collection<?>> {
    protected URI dbURI;
    protected RestTemplate restTemplate;
    protected ObjectMapper objectMapper;

    public EntityCollectionBulkExecutor() {
    }

    public EntityCollectionBulkExecutor(URI dbURI, RestTemplate restTemplate, ObjectMapper objectMapper) {
        this.dbURI = dbURI;
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
    }

    @Override
    public List<DocumentOperationResult> executeBulk(Collection<?> objects, boolean allOrNothing) {
        BulkDocumentBean bulkDocumentBean = new BulkDocumentBean(objects, allOrNothing);
        return this.restTemplate.post(this.dbURI.append("_bulk_docs").toString(), this.createHttpEntity(bulkDocumentBean), new BulkOperationResponseHandler(objects, this.objectMapper));
    }

    protected HttpEntity createHttpEntity(Object o) {
        return new JacksonableEntity(o, this.objectMapper);
    }
}

