/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl.jackson;

import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ektorp.docref.DocumentReferences;
import org.ektorp.impl.NameConventions;
import org.ektorp.util.Predicate;
import org.ektorp.util.ReflectionUtils;

public class EktorpAnnotationIntrospector
extends NopAnnotationIntrospector {
    private final Map<Class<?>, Set<String>> ignorableMethods = new HashMap();
    private final Set<Class<?>> annotatedClasses = new HashSet();

    public boolean isHandled(Annotation ann) {
        return DocumentReferences.class == ann.annotationType();
    }

    public boolean hasIgnoreMarker(AnnotatedMember member) {
        return super.hasIgnoreMarker(member);
    }

    public boolean isIgnorableField(AnnotatedField f) {
        return f.hasAnnotation(DocumentReferences.class);
    }

    public boolean isIgnorableMethod(AnnotatedMethod m) {
        Set<String> names = this.ignorableMethods.get(m.getDeclaringClass());
        if (names == null) {
            this.initIgnorableMethods(m.getDeclaringClass());
            names = this.ignorableMethods.get(m.getDeclaringClass());
        }
        return names.contains(m.getName());
    }

    public String[] findPropertiesToIgnore(Annotated ac) {
        if (ac instanceof AnnotatedClass) {
            return this.findPropertiesToIgnore((AnnotatedClass)ac);
        }
        return super.findPropertiesToIgnore(ac);
    }

    public String[] findPropertiesToIgnore(AnnotatedClass ac) {
        ArrayList<String> ignoreFields = null;
        for (AnnotatedField f : ac.fields()) {
            if (!this.isIgnorableField(f)) continue;
            if (ignoreFields == null) {
                ignoreFields = new ArrayList<String>();
            }
            ignoreFields.add(f.getName());
        }
        return ignoreFields != null ? ignoreFields.toArray(new String[ignoreFields.size()]) : null;
    }

    private void initIgnorableMethods(final Class<?> clazz) {
        final HashSet names = new HashSet();
        ReflectionUtils.eachField(clazz, new Predicate<Field>(){

            @Override
            public boolean apply(Field input) {
                if (ReflectionUtils.hasAnnotation(input, DocumentReferences.class)) {
                    EktorpAnnotationIntrospector.this.annotatedClasses.add(clazz);
                    names.add(NameConventions.getterName(input.getName()));
                }
                return false;
            }
        });
        this.ignorableMethods.put(clazz, names);
    }
}

