/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ReplicationCommand
implements Serializable {
    private static final long serialVersionUID = 6919908757724780784L;
    @JsonProperty(value="_local_id")
    public final String id;
    @JsonProperty
    public final String source;
    @JsonProperty
    public final String target;
    @JsonProperty
    public final String proxy;
    @JsonProperty
    public final String filter;
    @JsonProperty(value="doc_ids")
    public final Collection<String> docIds;
    @JsonProperty
    public final Boolean continuous;
    @JsonProperty
    public final Boolean cancel;
    @JsonProperty(value="query_params")
    public final Object queryParams;
    @JsonProperty(value="create_target")
    public final Boolean createTarget;
    @JsonProperty(value="since_seq")
    public final Object sinceSeq;

    private ReplicationCommand(Builder b) {
        this.id = b.id;
        this.source = b.source;
        this.target = b.target;
        this.proxy = b.proxy;
        this.filter = b.filter;
        this.docIds = b.docIds;
        this.continuous = b.continuous ? Boolean.TRUE : null;
        this.cancel = b.cancel ? Boolean.TRUE : null;
        this.createTarget = b.createTarget ? Boolean.TRUE : null;
        this.sinceSeq = b.sinceSeqAsLong != null ? b.sinceSeqAsLong : b.sinceSeqAsString;
        this.queryParams = b.queryParams;
    }

    public static class Builder {
        private String id;
        private String source;
        private String target;
        private String proxy;
        private String filter;
        private Collection<String> docIds;
        private boolean continuous;
        private boolean cancel;
        private boolean createTarget;
        private String sinceSeqAsString;
        private Long sinceSeqAsLong;
        private Object queryParams;

        public Builder id(String s) {
            this.id = s;
            return this;
        }

        public Builder source(String s) {
            this.source = s;
            return this;
        }

        public Builder target(String s) {
            this.target = s;
            return this;
        }

        public Builder proxy(String s) {
            this.proxy = s;
            return this;
        }

        public Builder filter(String s) {
            this.filter = s;
            return this;
        }

        public Builder docIds(Collection<String> docIds) {
            this.docIds = docIds;
            return this;
        }

        public Builder continuous(boolean b) {
            this.continuous = b;
            return this;
        }

        public Builder cancel(boolean b) {
            this.cancel = b;
            return this;
        }

        public Builder queryParams(Object o) {
            this.queryParams = o;
            return this;
        }

        public Builder createTarget(boolean b) {
            this.createTarget = b;
            return this;
        }

        public Builder sinceSeq(String sinceSeq) {
            try {
                this.sinceSeqAsLong = Long.parseLong(sinceSeq);
            }
            catch (NumberFormatException e) {
                this.sinceSeqAsString = sinceSeq;
            }
            return this;
        }

        public ReplicationCommand build() {
            return new ReplicationCommand(this);
        }
    }
}

