/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.http;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DecompressingHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.ektorp.http.HttpClient;
import org.ektorp.http.HttpCopyRequest;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.IdleConnectionMonitor;
import org.ektorp.http.PreemptiveAuthRequestInterceptor;
import org.ektorp.http.StdHttpResponse;
import org.ektorp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdHttpClient
implements HttpClient {
    private final org.apache.http.client.HttpClient client;
    private final org.apache.http.client.HttpClient backend;
    private static final Logger LOG = LoggerFactory.getLogger(StdHttpClient.class);

    public StdHttpClient(org.apache.http.client.HttpClient hc) {
        this(hc, hc);
    }

    public StdHttpClient(org.apache.http.client.HttpClient hc, org.apache.http.client.HttpClient backend) {
        this.client = hc;
        this.backend = backend;
    }

    public org.apache.http.client.HttpClient getClient() {
        return this.client;
    }

    public org.apache.http.client.HttpClient getBackend() {
        return this.backend;
    }

    @Override
    public HttpResponse delete(String uri) {
        return this.executeRequest((HttpRequestBase)new HttpDelete(uri));
    }

    @Override
    public HttpResponse get(String uri) {
        return this.executeRequest((HttpRequestBase)new HttpGet(uri));
    }

    @Override
    public HttpResponse get(String uri, Map<String, String> headers) {
        return this.executeRequest((HttpRequestBase)new HttpGet(uri), headers);
    }

    @Override
    public HttpResponse getUncached(String uri) {
        return this.executeRequest((HttpUriRequest)new HttpGet(uri), true);
    }

    @Override
    public HttpResponse postUncached(String uri, String content) {
        return this.executePutPost((HttpEntityEnclosingRequestBase)new HttpPost(uri), content, true);
    }

    @Override
    public HttpResponse post(String uri, String content) {
        return this.executePutPost((HttpEntityEnclosingRequestBase)new HttpPost(uri), content, false);
    }

    @Override
    public HttpResponse post(String uri, InputStream content) {
        InputStreamEntity e = new InputStreamEntity(content, -1L);
        e.setContentType("application/json");
        return this.post(uri, (HttpEntity)e);
    }

    @Override
    public HttpResponse post(String uri, HttpEntity httpEntity) {
        HttpPost post = new HttpPost(uri);
        post.setEntity(httpEntity);
        return this.executeRequest((HttpUriRequest)post, true);
    }

    @Override
    public HttpResponse put(String uri, String content) {
        return this.executePutPost((HttpEntityEnclosingRequestBase)new HttpPut(uri), content, false);
    }

    @Override
    public HttpResponse put(String uri) {
        return this.executeRequest((HttpRequestBase)new HttpPut(uri));
    }

    @Override
    public HttpResponse put(String uri, InputStream data, String contentType, long contentLength) {
        InputStreamEntity e = new InputStreamEntity(data, contentLength);
        e.setContentType(contentType);
        return this.put(uri, (HttpEntity)e);
    }

    @Override
    public HttpResponse put(String uri, HttpEntity httpEntity) {
        HttpPut hp = new HttpPut(uri);
        hp.setEntity(httpEntity);
        return this.executeRequest((HttpRequestBase)hp);
    }

    @Override
    public HttpResponse head(String uri) {
        return this.executeRequest((HttpRequestBase)new HttpHead(uri));
    }

    protected HttpResponse executePutPost(HttpEntityEnclosingRequestBase request, String content, boolean useBackend) {
        try {
            LOG.trace("Content: {}", (Object)content);
            StringEntity e = new StringEntity(content, "UTF-8");
            e.setContentType("application/json");
            request.setEntity((HttpEntity)e);
            return this.executeRequest((HttpUriRequest)request, useBackend);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    protected HttpResponse executeRequest(HttpRequestBase request, Map<String, String> headers) {
        for (Map.Entry<String, String> header : headers.entrySet()) {
            request.setHeader(header.getKey(), header.getValue());
        }
        return this.executeRequest(request);
    }

    protected HttpResponse executeRequest(HttpUriRequest request, boolean useBackend) {
        try {
            org.apache.http.HttpResponse rsp = useBackend ? this.backend.execute(request) : this.client.execute(this.getHttpHost(), (HttpRequest)request);
            LOG.trace("{} {} {} {}", new Object[]{request.getMethod(), request.getURI(), rsp.getStatusLine().getStatusCode(), rsp.getStatusLine().getReasonPhrase()});
            return this.createHttpResponse(rsp, request);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    protected HttpResponse createHttpResponse(org.apache.http.HttpResponse rsp, HttpUriRequest httpRequest) {
        return new StdHttpResponse(rsp.getEntity(), rsp.getStatusLine(), httpRequest, rsp.getFirstHeader("ETag"));
    }

    protected HttpResponse executeRequest(HttpRequestBase request) {
        return this.executeRequest((HttpUriRequest)request, false);
    }

    @Override
    public HttpResponse copy(String sourceUri, String destination) {
        return this.executeRequest((HttpUriRequest)new HttpCopyRequest(sourceUri, destination), true);
    }

    @Override
    public void shutdown() {
        this.client.getConnectionManager().shutdown();
    }

    protected HttpHost getHttpHost() {
        return (HttpHost)this.client.getParams().getParameter("http.default-host");
    }

    public static class WithCachingBuilder {
        public static org.apache.http.client.HttpClient withCaching(org.apache.http.client.HttpClient client, int maxCacheEntries, int maxObjectSizeBytes) {
            CacheConfig cacheConfig = new CacheConfig();
            cacheConfig.setMaxCacheEntries(maxCacheEntries);
            cacheConfig.setMaxObjectSize((long)maxObjectSizeBytes);
            return new CachingHttpClient(client, cacheConfig);
        }
    }

    public static class Builder {
        protected String host = "localhost";
        protected int port = 5984;
        protected int maxConnections = 20;
        protected int connectionTimeout = 1000;
        protected int socketTimeout = 10000;
        protected ClientConnectionManager conman;
        protected int proxyPort = -1;
        protected String proxy = null;
        protected boolean enableSSL = false;
        protected boolean relaxedSSLSettings = false;
        protected SSLSocketFactory sslSocketFactory;
        protected String username;
        protected String password;
        protected boolean cleanupIdleConnections = true;
        protected boolean useExpectContinue = true;
        protected boolean caching = true;
        protected boolean compression;
        protected int maxObjectSizeBytes = 8192;
        protected int maxCacheEntries = 1000;

        public Builder url(String s) throws MalformedURLException {
            if (s == null) {
                return this;
            }
            return this.url(new URL(s));
        }

        public Builder url(URL url) {
            String[] userInfoParts;
            this.host = url.getHost();
            this.port = url.getPort();
            if (url.getUserInfo() != null && (userInfoParts = url.getUserInfo().split(":")).length == 2) {
                this.username = userInfoParts[0];
                this.password = userInfoParts[1];
            }
            this.enableSSL("https".equals(url.getProtocol()));
            if (this.port == -1) {
                this.port = this.enableSSL ? 443 : 80;
            }
            return this;
        }

        public Builder host(String s) {
            this.host = s;
            return this;
        }

        public Builder proxyPort(int p) {
            this.proxyPort = p;
            return this;
        }

        public Builder proxy(String s) {
            this.proxy = s;
            return this;
        }

        public Builder compression(boolean b) {
            this.compression = b;
            return this;
        }

        public Builder caching(boolean b) {
            this.caching = b;
            return this;
        }

        public Builder maxCacheEntries(int m) {
            this.maxCacheEntries = m;
            return this;
        }

        public Builder maxObjectSizeBytes(int m) {
            this.maxObjectSizeBytes = m;
            return this;
        }

        public ClientConnectionManager configureConnectionManager(HttpParams params) {
            if (this.conman == null) {
                SchemeRegistry schemeRegistry = new SchemeRegistry();
                schemeRegistry.register(this.configureScheme());
                PoolingClientConnectionManager cm = new PoolingClientConnectionManager(schemeRegistry);
                cm.setMaxTotal(this.maxConnections);
                cm.setDefaultMaxPerRoute(this.maxConnections);
                this.conman = cm;
            }
            if (this.cleanupIdleConnections) {
                IdleConnectionMonitor.monitor(this.conman);
            }
            return this.conman;
        }

        protected Scheme configureScheme() {
            if (this.enableSSL) {
                try {
                    if (this.sslSocketFactory == null) {
                        SSLContext context = SSLContext.getInstance("TLS");
                        if (this.relaxedSSLSettings) {
                            context.init(null, new TrustManager[]{new X509TrustManager(){

                                @Override
                                public X509Certificate[] getAcceptedIssuers() {
                                    return null;
                                }

                                @Override
                                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                                }

                                @Override
                                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                                }
                            }}, null);
                        } else {
                            context.init(null, null, null);
                        }
                        this.sslSocketFactory = this.relaxedSSLSettings ? new SSLSocketFactory(context, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER) : new SSLSocketFactory(context);
                    }
                    return new Scheme("https", this.port, (SchemeSocketFactory)this.sslSocketFactory);
                }
                catch (Exception e) {
                    throw Exceptions.propagate(e);
                }
            }
            return new Scheme("http", this.port, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
        }

        public org.apache.http.client.HttpClient configureClient() {
            HttpParams params = this.configureHttpParams();
            ClientConnectionManager connectionManager = this.configureConnectionManager(params);
            DefaultHttpClient client = new DefaultHttpClient(connectionManager, params);
            if (this.username != null && this.password != null) {
                client.getCredentialsProvider().setCredentials(new AuthScope(this.host, this.port, AuthScope.ANY_REALM), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
                client.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuthRequestInterceptor(), 0);
            }
            if (this.compression) {
                return new DecompressingHttpClient((org.apache.http.client.HttpClient)client);
            }
            return client;
        }

        protected HttpParams configureHttpParams() {
            BasicHttpParams params = new BasicHttpParams();
            HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)this.useExpectContinue);
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this.connectionTimeout);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.socketTimeout);
            HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)Boolean.TRUE);
            String protocol = "http";
            if (this.enableSSL) {
                protocol = "https";
            }
            params.setParameter("http.default-host", (Object)new HttpHost(this.host, this.port, protocol));
            if (this.proxy != null) {
                params.setParameter("http.route.default-proxy", (Object)new HttpHost(this.proxy, this.proxyPort, protocol));
            }
            return params;
        }

        public Builder port(int i) {
            this.port = i;
            return this;
        }

        public Builder username(String s) {
            this.username = s;
            return this;
        }

        public Builder password(String s) {
            this.password = s;
            return this;
        }

        public Builder maxConnections(int i) {
            this.maxConnections = i;
            return this;
        }

        public Builder connectionTimeout(int i) {
            this.connectionTimeout = i;
            return this;
        }

        public Builder socketTimeout(int i) {
            this.socketTimeout = i;
            return this;
        }

        public Builder cleanupIdleConnections(boolean b) {
            this.cleanupIdleConnections = b;
            return this;
        }

        public Builder connectionManager(ClientConnectionManager cm) {
            this.conman = cm;
            return this;
        }

        public Builder enableSSL(boolean b) {
            this.enableSSL = b;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory f) {
            this.sslSocketFactory = f;
            return this;
        }

        public Builder relaxedSSLSettings(boolean b) {
            this.relaxedSSLSettings = b;
            return this;
        }

        public Builder useExpectContinue(boolean b) {
            this.useExpectContinue = b;
            return this;
        }

        public HttpClient build() {
            org.apache.http.client.HttpClient client;
            org.apache.http.client.HttpClient cachingHttpClient = client = this.configureClient();
            if (this.caching) {
                cachingHttpClient = WithCachingBuilder.withCaching(client, this.maxCacheEntries, this.maxObjectSizeBytes);
            }
            return new StdHttpClient(cachingHttpClient, client);
        }
    }
}

