/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import org.ektorp.Page;
import org.ektorp.PageRequest;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.StdResponseHandler;
import org.ektorp.impl.QueryResultParser;
import org.ektorp.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageResponseHandler<T>
extends StdResponseHandler<Page<T>> {
    private final QueryResultParser<T> parser;
    private final PageRequest pageRequest;
    private static final Logger LOG = LoggerFactory.getLogger(PageResponseHandler.class);

    public PageResponseHandler(PageRequest pr, Class<T> docType, ObjectMapper om) {
        Assert.notNull(om, "ObjectMapper may not be null");
        Assert.notNull(docType, "docType may not be null");
        this.parser = new QueryResultParser<T>(docType, om);
        this.pageRequest = pr;
    }

    public PageResponseHandler(PageRequest pr, Class<T> docType, ObjectMapper om, boolean ignoreNotFound) {
        Assert.notNull(om, "ObjectMapper may not be null");
        Assert.notNull(docType, "docType may not be null");
        this.parser = new QueryResultParser<T>(docType, om);
        this.parser.setIgnoreNotFound(ignoreNotFound);
        this.pageRequest = pr;
    }

    @Override
    @SuppressWarnings(value={"DB_DUPLICATE_BRANCHES"})
    public Page<T> success(HttpResponse hr) throws Exception {
        boolean hasMore;
        this.parser.parseResult(hr.getContent());
        List<T> rows = this.parser.getRows();
        int rowsSize = rows.size();
        LOG.debug("got {} rows", (Object)rowsSize);
        if (this.pageRequest.isBack()) {
            Collections.reverse(rows);
        }
        int offset = this.pageRequest.isBack() ? 1 : 1;
        String nextId = this.parser.getLastId();
        JsonNode nextKey = this.parser.getLastKey();
        PageRequest.Builder b = this.pageRequest.nextRequest(nextKey, nextId);
        int currentPage = b.getPageNo();
        PageRequest nextRequest = b.page(currentPage + 1).build();
        PageRequest previousRequest = currentPage == 1 ? PageRequest.firstPage(this.pageRequest.getPageSize()) : b.back(true).page(currentPage - 1).build();
        boolean bl = hasMore = rowsSize == this.pageRequest.getPageSize() + offset;
        if (hasMore) {
            rows.remove(rows.size() - 1);
        } else if (!this.pageRequest.isBack()) {
            nextRequest = null;
        }
        if (currentPage == 0) {
            previousRequest = null;
        }
        return new Page<T>(rows, this.parser.getTotalRows(), this.pageRequest.getPageSize(), previousRequest, nextRequest);
    }
}

