/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ektorp.DbAccessException;
import org.ektorp.ViewResultException;

public class QueryResultParser<T> {
    private static final String NOT_FOUND_ERROR = "not_found";
    private static final String ROWS_FIELD_NAME = "rows";
    private static final String VALUE_FIELD_NAME = "value";
    private static final String ID_FIELD_NAME = "id";
    private static final String ERROR_FIELD_NAME = "error";
    private static final String KEY_FIELD_NAME = "key";
    private static final String INCLUDED_DOC_FIELD_NAME = "doc";
    private static final String TOTAL_ROWS_FIELD_NAME = "total_rows";
    private static final String OFFSET_FIELD_NAME = "offset";
    private static final String UPDATE_SEQUENCE_NAME = "update_seq";
    private int totalRows = -1;
    private long offset = -1L;
    private List<T> rows;
    private Long updateSequence;
    private String firstId;
    private JsonNode firstKey;
    private String lastId;
    private JsonNode lastKey;
    private final ObjectMapper mapper;
    private final Class<T> type;
    private boolean ignoreNotFound;

    public QueryResultParser(Class<T> type, ObjectMapper mapper) {
        this.type = type;
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseResult(InputStream json) throws IOException {
        JsonParser jp = this.mapper.getFactory().createParser(json);
        try {
            this.parseResult(jp);
        }
        finally {
            jp.close();
        }
    }

    private void parseResult(JsonParser jp) throws IOException {
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new DbAccessException("Expected data to start with an Object");
        }
        HashMap<String, String> errorFields = new HashMap<String, String>();
        while (jp.nextValue() != JsonToken.END_OBJECT) {
            String currentName = jp.getCurrentName();
            if (OFFSET_FIELD_NAME.equals(currentName)) {
                this.offset = jp.getLongValue();
                continue;
            }
            if (TOTAL_ROWS_FIELD_NAME.equals(currentName)) {
                this.totalRows = jp.getIntValue();
                continue;
            }
            if (ROWS_FIELD_NAME.equals(currentName)) {
                this.rows = new ArrayList<T>();
                this.parseRows(jp);
                continue;
            }
            if (UPDATE_SEQUENCE_NAME.equals(currentName)) {
                this.updateSequence = jp.getLongValue();
                continue;
            }
            errorFields.put(jp.getCurrentName(), jp.getText());
        }
        if (!errorFields.isEmpty()) {
            JsonNode error = (JsonNode)this.mapper.convertValue(errorFields, JsonNode.class);
            throw new DbAccessException(error.toString());
        }
    }

    private void parseRows(JsonParser jp) throws IOException {
        if (jp.getCurrentToken() != JsonToken.START_ARRAY) {
            throw new DbAccessException("Expected rows to start with an Array");
        }
        String dataField = null;
        while (dataField == null && jp.nextToken() == JsonToken.START_OBJECT) {
            Row row = (Row)jp.readValueAs(Row.class);
            if (row.error != null) {
                if (this.ignoreError(row.error)) continue;
                throw new ViewResultException(row.key, row.error);
            }
            if (row.doc != null) {
                dataField = INCLUDED_DOC_FIELD_NAME;
                this.rows.add(this.mapper.readValue(row.doc.traverse(jp.getCodec()), this.type));
            } else {
                dataField = VALUE_FIELD_NAME;
                this.rows.add(this.mapper.readValue(row.value.traverse(jp.getCodec()), this.type));
            }
            this.firstId = row.id;
            this.firstKey = row.key;
        }
        if (dataField == null) {
            return;
        }
        while (jp.nextToken() != JsonToken.END_ARRAY) {
            String currentId = null;
            JsonNode currentKey = null;
            String error = null;
            Object value = null;
            while (jp.nextValue() != JsonToken.END_OBJECT) {
                String currentName = jp.getCurrentName();
                if (ID_FIELD_NAME.equals(currentName)) {
                    currentId = jp.getText();
                    continue;
                }
                if (KEY_FIELD_NAME.equals(currentName)) {
                    currentKey = (JsonNode)jp.readValueAsTree();
                    continue;
                }
                if (dataField.equals(currentName)) {
                    value = jp.readValueAs(this.type);
                    continue;
                }
                if (ERROR_FIELD_NAME.equals(currentName)) {
                    error = jp.getText();
                    continue;
                }
                jp.skipChildren();
            }
            if (error != null && !this.ignoreError(error)) {
                throw new ViewResultException(currentKey, error);
            }
            if (value == null) continue;
            this.lastId = currentId;
            this.lastKey = currentKey;
            this.rows.add(value);
        }
    }

    private boolean ignoreError(String error) {
        return this.ignoreNotFound && NOT_FOUND_ERROR.equals(error);
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public long getOffset() {
        return this.offset;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public String getLastId() {
        return this.lastId;
    }

    public JsonNode getLastKey() {
        return this.lastKey;
    }

    public String getFirstId() {
        return this.firstId;
    }

    public JsonNode getFirstKey() {
        return this.firstKey;
    }

    public void setIgnoreNotFound(boolean ignoreNotFound) {
        this.ignoreNotFound = ignoreNotFound;
    }

    public Long getUpdateSequence() {
        return this.updateSequence;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    private static class Row {
        private String id;
        private JsonNode key;
        private JsonNode value;
        private JsonNode doc;
        private String error;

        private Row() {
        }
    }
}

