/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.ektorp.AttachmentInputStream;
import org.ektorp.CouchDbConnector;
import org.ektorp.CouchDbInstance;
import org.ektorp.DbAccessException;
import org.ektorp.DbInfo;
import org.ektorp.DbPath;
import org.ektorp.DesignDocInfo;
import org.ektorp.DocumentOperationResult;
import org.ektorp.LocalBulkBuffer;
import org.ektorp.Options;
import org.ektorp.Page;
import org.ektorp.PageRequest;
import org.ektorp.PurgeResult;
import org.ektorp.ReplicationCommand;
import org.ektorp.ReplicationStatus;
import org.ektorp.Revision;
import org.ektorp.Security;
import org.ektorp.Status;
import org.ektorp.StreamingChangesResult;
import org.ektorp.StreamingViewResult;
import org.ektorp.UpdateConflictException;
import org.ektorp.UpdateHandlerRequest;
import org.ektorp.ViewQuery;
import org.ektorp.ViewResult;
import org.ektorp.changes.ChangesCommand;
import org.ektorp.changes.ChangesFeed;
import org.ektorp.changes.DocumentChange;
import org.ektorp.http.HttpClient;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.ResponseCallback;
import org.ektorp.http.RestTemplate;
import org.ektorp.http.StdResponseHandler;
import org.ektorp.http.URI;
import org.ektorp.impl.BulkExecutor;
import org.ektorp.impl.BulkOperationCollectionBulkExecutor;
import org.ektorp.impl.DefaultLocalBulkBuffer;
import org.ektorp.impl.DefaultQueryExecutor;
import org.ektorp.impl.DocIdResponseHandler;
import org.ektorp.impl.EmbeddedDocViewResponseHandler;
import org.ektorp.impl.InputStreamWrapperBulkExecutor;
import org.ektorp.impl.JsonSerializer;
import org.ektorp.impl.ObjectMapperFactory;
import org.ektorp.impl.PageResponseHandler;
import org.ektorp.impl.QueryExecutor;
import org.ektorp.impl.RevisionResponseHandler;
import org.ektorp.impl.StdObjectMapperFactory;
import org.ektorp.impl.StreamingJsonSerializer;
import org.ektorp.impl.changes.ContinuousChangesFeed;
import org.ektorp.impl.changes.StdDocumentChange;
import org.ektorp.util.Assert;
import org.ektorp.util.Documents;
import org.ektorp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdCouchDbConnector
implements CouchDbConnector {
    private static final int DEFAULT_HEARTBEAT_INTERVAL = 9000;
    private static final Logger LOG = LoggerFactory.getLogger(StdCouchDbConnector.class);
    private static final ResponseCallback<Void> VOID_RESPONSE_HANDLER = new StdResponseHandler<Void>();
    protected final ObjectMapper objectMapper;
    private JsonSerializer jsonSerializer;
    protected final URI dbURI;
    private final String dbName;
    protected final RestTemplate restTemplate;
    protected QueryExecutor queryExecutor;
    private final CouchDbInstance dbInstance;
    protected final RevisionResponseHandler revisionHandler;
    private final DocIdResponseHandler docIdResponseHandler;
    private LocalBulkBuffer localBulkBuffer;
    private BulkExecutor<Collection<?>> collectionBulkExecutor;
    private BulkExecutor<InputStream> inputStreamBulkExecutor;
    private static final Options EMPTY_OPTIONS = new Options();

    public StdCouchDbConnector(String databaseName, CouchDbInstance dbInstance) {
        this(databaseName, dbInstance, new StdObjectMapperFactory());
    }

    public StdCouchDbConnector(String databaseName, CouchDbInstance dbi, ObjectMapperFactory om) {
        Assert.hasText(databaseName, "DatabaseName may not be null or empty");
        Assert.notNull(dbi, "CouchDbInstance may not be null");
        Assert.notNull(om, "ObjectMapperFactory may not be null");
        DbPath dbp = DbPath.fromString(databaseName);
        this.dbName = dbp.getDbName();
        this.dbURI = URI.prototype(dbp.getPath());
        this.dbInstance = dbi;
        this.objectMapper = om.createObjectMapper(this);
        this.jsonSerializer = new StreamingJsonSerializer(this.objectMapper);
        this.restTemplate = new RestTemplate(dbi.getConnection());
        this.revisionHandler = new RevisionResponseHandler(this.objectMapper);
        this.docIdResponseHandler = new DocIdResponseHandler(this.objectMapper);
        this.queryExecutor = new DefaultQueryExecutor(this.restTemplate);
        this.collectionBulkExecutor = new BulkOperationCollectionBulkExecutor(this.dbURI, this.restTemplate, this.objectMapper){

            @Override
            protected JsonSerializer getJsonSerializer() {
                return StdCouchDbConnector.this.jsonSerializer;
            }
        };
        this.localBulkBuffer = new DefaultLocalBulkBuffer(){

            protected BulkExecutor getBulkExecutor() {
                return StdCouchDbConnector.this.collectionBulkExecutor;
            }
        };
        this.inputStreamBulkExecutor = new InputStreamWrapperBulkExecutor(this.dbURI, this.restTemplate, this.objectMapper);
    }

    public void setLocalBulkBuffer(LocalBulkBuffer localBulkBuffer) {
        this.localBulkBuffer = localBulkBuffer;
    }

    public void setCollectionBulkExecutor(BulkExecutor<Collection<?>> collectionBulkExecutor) {
        this.collectionBulkExecutor = collectionBulkExecutor;
    }

    public void setInputStreamBulkExecutor(BulkExecutor<InputStream> inputStreamBulkExecutor) {
        this.inputStreamBulkExecutor = inputStreamBulkExecutor;
    }

    public void setQueryExecutor(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    @Override
    public String path() {
        return this.dbURI.toString();
    }

    @Override
    public void create(Object o) {
        DocumentOperationResult result;
        Assert.notNull(o, "Document may not be null");
        Assert.isTrue(Documents.isNew(o), "Object must be new");
        String json = this.serializeToJson(o);
        String id = Documents.getId(o);
        if (id != null && id.length() != 0) {
            result = this.restTemplate.put(this.URIWithDocId(id), json, this.revisionHandler);
        } else {
            result = this.restTemplate.post(this.dbURI.toString(), json, this.revisionHandler);
            Documents.setId(o, result.getId());
        }
        Documents.setRevision(o, result.getRevision());
    }

    @Override
    public void create(String id, Object node) {
        this.assertDocIdHasValue(id);
        Assert.notNull(node, "node may not be null");
        this.restTemplate.put(this.URIWithDocId(id), this.serializeToJson(node));
    }

    protected String URIWithDocId(String id) {
        return this.dbURI.append(id).toString();
    }

    @Override
    public boolean contains(String id) {
        return this.restTemplate.head(this.URIWithDocId(id), new ResponseCallback<Boolean>(){

            @Override
            public Boolean error(HttpResponse hr) {
                if (hr.getCode() == 404) {
                    return Boolean.FALSE;
                }
                throw new DbAccessException(hr.toString());
            }

            @Override
            public Boolean success(HttpResponse hr) throws Exception {
                return Boolean.TRUE;
            }
        });
    }

    @Override
    public String createAttachment(String docId, AttachmentInputStream data) {
        return this.createAttachment(docId, null, data);
    }

    @Override
    public String createAttachment(String docId, String revision, AttachmentInputStream data) {
        this.assertDocIdHasValue(docId);
        URI uri = this.dbURI.append(docId).append(data.getId());
        if (revision != null) {
            uri.param("rev", revision);
        }
        return this.restTemplate.put(uri.toString(), data, data.getContentType(), data.getContentLength(), this.revisionHandler).getRevision();
    }

    @Override
    public AttachmentInputStream getAttachment(String id, String attachmentId) {
        this.assertDocIdHasValue(id);
        Assert.hasText(attachmentId, "attachmentId may not be null or empty");
        LOG.trace("fetching attachment for doc: {} attachmentId: {}", (Object)id, (Object)attachmentId);
        return this.getAttachment(attachmentId, this.dbURI.append(id).append(attachmentId));
    }

    @Override
    public AttachmentInputStream getAttachment(String id, String attachmentId, String revision) {
        this.assertDocIdHasValue(id);
        Assert.hasText(attachmentId, "attachmentId may not be null or empty");
        Assert.hasText(revision, "revision may not be null or empty");
        LOG.trace("fetching attachment for doc: {} attachmentId: {}", (Object)id, (Object)attachmentId);
        return this.getAttachment(attachmentId, this.dbURI.append(id).append(attachmentId).param("rev", revision));
    }

    private AttachmentInputStream getAttachment(String attachmentId, URI uri) {
        HttpResponse r = this.restTemplate.get(uri.toString());
        return new AttachmentInputStream(attachmentId, r.getContent(), r.getContentType(), r.getContentLength());
    }

    @Override
    public String delete(Object o) {
        Assert.notNull(o, "document may not be null");
        return this.delete(Documents.getId(o), Documents.getRevision(o));
    }

    @Override
    public PurgeResult purge(Map<String, List<String>> revisionsToPurge) {
        return this.restTemplate.post(this.dbURI.append("_purge").toString(), this.serializeToJson(revisionsToPurge), new StdResponseHandler<PurgeResult>(){

            @Override
            public PurgeResult success(HttpResponse hr) throws Exception {
                return (PurgeResult)StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), PurgeResult.class);
            }
        });
    }

    @Override
    public <T> T get(Class<T> c, String id) {
        return this.get(c, id, EMPTY_OPTIONS);
    }

    @Override
    public <T> T get(final Class<T> c, String id, Options options) {
        Assert.notNull(c, "Class may not be null");
        this.assertDocIdHasValue(id);
        URI uri = this.dbURI.append(id);
        this.applyOptions(options, uri);
        return this.restTemplate.get(uri.toString(), new StdResponseHandler<T>(){

            @Override
            public T success(HttpResponse hr) throws Exception {
                return StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), c);
            }
        });
    }

    @Override
    public <T> T get(Class<T> c, String id, String rev) {
        Assert.notNull(c, "Class may not be null");
        this.assertDocIdHasValue(id);
        Assert.hasText(rev, "Revision may not be null or empty");
        return this.get(c, id, new Options().revision(rev));
    }

    @Override
    public <T> T getWithConflicts(Class<T> c, String id) {
        Assert.notNull(c, "Class may not be null");
        this.assertDocIdHasValue(id);
        return this.get(c, id, new Options().includeConflicts());
    }

    @Override
    public <T> T find(Class<T> c, String id) {
        return this.find(c, id, EMPTY_OPTIONS);
    }

    @Override
    public <T> T find(final Class<T> c, String id, Options options) {
        Assert.notNull(c, "Class may not be null");
        this.assertDocIdHasValue(id);
        URI uri = this.dbURI.append(id);
        this.applyOptions(options, uri);
        return this.restTemplate.get(uri.toString(), new StdResponseHandler<T>(){

            @Override
            public T success(HttpResponse hr) throws Exception {
                return StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), c);
            }

            @Override
            public T error(HttpResponse hr) {
                return hr.getCode() == 404 ? null : (Object)super.error(hr);
            }
        });
    }

    private void applyOptions(Options options, URI uri) {
        if (options != null && !options.isEmpty()) {
            uri.params(options.getOptions());
        }
    }

    @Override
    public List<Revision> getRevisions(String id) {
        this.assertDocIdHasValue(id);
        return this.restTemplate.get(this.dbURI.append(id).param("revs_info", "true").toString(), new StdResponseHandler<List<Revision>>(){

            @Override
            public List<Revision> success(HttpResponse hr) throws Exception {
                JsonNode root = (JsonNode)StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), JsonNode.class);
                ArrayList<Revision> revs = new ArrayList<Revision>();
                Iterator i = root.get("_revs_info").elements();
                while (i.hasNext()) {
                    JsonNode rev = (JsonNode)i.next();
                    revs.add(new Revision(rev.get("rev").textValue(), rev.get("status").textValue()));
                }
                return revs;
            }

            @Override
            public List<Revision> error(HttpResponse hr) {
                if (hr.getCode() == 404) {
                    return Collections.emptyList();
                }
                return (List)super.error(hr);
            }
        });
    }

    @Override
    public String getCurrentRevision(String id) {
        this.assertDocIdHasValue(id);
        return this.restTemplate.head(this.dbURI.append(id).toString(), new StdResponseHandler<String>(){

            @Override
            public String success(HttpResponse hr) throws Exception {
                return hr.getETag();
            }
        });
    }

    @Override
    public InputStream getAsStream(String id) {
        this.assertDocIdHasValue(id);
        return this.getAsStream(id, EMPTY_OPTIONS);
    }

    @Override
    public InputStream getAsStream(String id, Options options) {
        URI uri = this.dbURI.append(id);
        this.applyOptions(options, uri);
        HttpResponse r = this.restTemplate.get(uri.toString());
        return r.getContent();
    }

    @Override
    public InputStream getAsStream(String id, String rev) {
        this.assertDocIdHasValue(id);
        Assert.hasText(rev, "Revision may not be null or empty");
        return this.getAsStream(id, new Options().revision(rev));
    }

    @Override
    public void update(final Object o) {
        Assert.notNull(o, "Document cannot be null");
        final String id = Documents.getId(o);
        this.assertDocIdHasValue(id);
        this.restTemplate.put(this.dbURI.append(id).toString(), this.serializeToJson(o), new StdResponseHandler<Void>(){

            @Override
            public Void success(HttpResponse hr) throws Exception {
                JsonNode n = (JsonNode)StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), JsonNode.class);
                Documents.setRevision(o, n.get("rev").textValue());
                return null;
            }

            @Override
            public Void error(HttpResponse hr) {
                if (hr.getCode() == 409) {
                    throw new UpdateConflictException(id, Documents.getRevision(o));
                }
                return (Void)super.error(hr);
            }
        });
    }

    @Override
    public String delete(String id, String revision) {
        this.assertDocIdHasValue(id);
        return this.restTemplate.delete(this.dbURI.append(id).param("rev", revision).toString(), this.revisionHandler).getRevision();
    }

    @Override
    public String copy(String sourceDocId, String targetDocId) {
        return this.copy(sourceDocId, targetDocId, null);
    }

    @Override
    public String copy(String sourceDocId, String targetDocId, String targetRevision) {
        String destinationUri = targetRevision != null ? targetDocId + "?rev=" + targetRevision : targetDocId;
        return this.restTemplate.copy(this.dbURI.append(sourceDocId).toString(), destinationUri, this.revisionHandler).getRevision();
    }

    @Override
    public List<String> getAllDocIds() {
        return this.restTemplate.get(this.dbURI.append("_all_docs").toString(), this.docIdResponseHandler);
    }

    @Override
    public void createDatabaseIfNotExists() {
        this.dbInstance.createDatabaseIfNotExists(this.dbName);
    }

    @Override
    public String getDatabaseName() {
        return this.dbName;
    }

    @Override
    public <T> List<T> queryView(ViewQuery query, Class<T> type) {
        Assert.notNull(query, "query may not be null");
        query.dbPath(this.dbURI.toString());
        EmbeddedDocViewResponseHandler<T> rh = new EmbeddedDocViewResponseHandler<T>(type, this.objectMapper, query.isIgnoreNotFound());
        return (List)this.executeQuery(query, rh);
    }

    protected <T> T executeQuery(ViewQuery query, ResponseCallback<T> rh) {
        return this.queryExecutor.executeQuery(query, rh);
    }

    @Override
    public <T> Page<T> queryForPage(ViewQuery query, PageRequest pr, Class<T> type) {
        Assert.notNull(query, "query may not be null");
        Assert.notNull(pr, "PageRequest may not be null");
        Assert.notNull(type, "type may not be null");
        query.dbPath(this.dbURI.toString());
        LOG.debug("startKey: {}", pr.getStartKey());
        LOG.debug("startDocId: {}", (Object)pr.getStartKeyDocId());
        PageResponseHandler<T> ph = new PageResponseHandler<T>(pr, type, this.objectMapper, query.isIgnoreNotFound());
        query = PageRequest.applyPagingParameters(query, pr);
        return (Page)this.executeQuery(query, ph);
    }

    @Override
    public ViewResult queryView(final ViewQuery query) {
        Assert.notNull(query, "query cannot be null");
        query.dbPath(this.dbURI.toString());
        StdResponseHandler<ViewResult> rh = new StdResponseHandler<ViewResult>(){

            @Override
            public ViewResult success(HttpResponse hr) throws Exception {
                return new ViewResult(StdCouchDbConnector.this.objectMapper.readTree(hr.getContent()), query.isIgnoreNotFound());
            }
        };
        return this.executeQuery(query, rh);
    }

    @Override
    public StreamingViewResult queryForStreamingView(ViewQuery query) {
        return new StreamingViewResult(this.objectMapper, this.queryForHttpResponse(query), query.isIgnoreNotFound());
    }

    @Override
    public InputStream queryForStream(ViewQuery query) {
        return this.queryForHttpResponse(query).getContent();
    }

    private HttpResponse queryForHttpResponse(ViewQuery query) {
        Assert.notNull(query, "query cannot be null");
        query.dbPath(this.dbURI.toString());
        return query.hasMultipleKeys() ? this.restTemplate.postUncached(query.buildQuery(), query.getKeysAsJson()) : this.restTemplate.getUncached(query.buildQuery());
    }

    @Override
    public String deleteAttachment(String docId, String revision, String attachmentId) {
        return this.restTemplate.delete(this.dbURI.append(docId).append(attachmentId).param("rev", revision).toString(), this.revisionHandler).getRevision();
    }

    protected void assertDocIdHasValue(String docId) {
        Assert.hasText(docId, "document id cannot be empty");
    }

    @Override
    public HttpClient getConnection() {
        return this.dbInstance.getConnection();
    }

    @Override
    public DbInfo getDbInfo() {
        return this.restTemplate.get(this.dbURI.toString(), new StdResponseHandler<DbInfo>(){

            @Override
            public DbInfo success(HttpResponse hr) throws Exception {
                return (DbInfo)StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), DbInfo.class);
            }
        });
    }

    @Override
    public Security getSecurity() {
        return this.restTemplate.get(this.securityPath(), new StdResponseHandler<Security>(){

            @Override
            public Security success(HttpResponse hr) throws Exception {
                return (Security)StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), Security.class);
            }
        });
    }

    @Override
    public Status updateSecurity(Security security) {
        try {
            return this.restTemplate.put(this.securityPath(), this.objectMapper.writeValueAsString((Object)security), new StdResponseHandler<Status>(){

                @Override
                public Status success(HttpResponse hr) throws Exception {
                    return (Status)StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), Status.class);
                }
            });
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to update security: " + e.getMessage());
        }
    }

    @Override
    public DesignDocInfo getDesignDocInfo(String designDocId) {
        Assert.hasText(designDocId, "designDocId may not be null or empty");
        String uri = this.dbURI.append("_design").append(designDocId).append("_info").toString();
        return this.restTemplate.get(uri, new StdResponseHandler<DesignDocInfo>(){

            @Override
            public DesignDocInfo success(HttpResponse hr) throws Exception {
                return (DesignDocInfo)StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), DesignDocInfo.class);
            }
        });
    }

    @Override
    public void compact() {
        this.restTemplate.post(this.dbURI.append("_compact").toString(), "not_used", VOID_RESPONSE_HANDLER);
    }

    @Override
    public void cleanupViews() {
        this.restTemplate.post(this.dbURI.append("_view_cleanup").toString(), "not_used", VOID_RESPONSE_HANDLER);
    }

    @Override
    public ReplicationStatus replicateFrom(String source) {
        ReplicationCommand cmd = new ReplicationCommand.Builder().target(this.dbName).source(source).build();
        return this.dbInstance.replicate(cmd);
    }

    @Override
    public ReplicationStatus replicateFrom(String source, Collection<String> docIds) {
        ReplicationCommand cmd = new ReplicationCommand.Builder().target(this.dbName).source(source).docIds(docIds).build();
        return this.dbInstance.replicate(cmd);
    }

    @Override
    public ReplicationStatus replicateTo(String target) {
        ReplicationCommand cmd = new ReplicationCommand.Builder().target(target).source(this.dbName).build();
        return this.dbInstance.replicate(cmd);
    }

    @Override
    public ReplicationStatus replicateTo(String target, Collection<String> docIds) {
        ReplicationCommand cmd = new ReplicationCommand.Builder().target(target).source(this.dbName).docIds(docIds).build();
        return this.dbInstance.replicate(cmd);
    }

    @Override
    public void compactViews(String designDocumentId) {
        Assert.hasText(designDocumentId, "designDocumentId may not be null or empty");
        this.restTemplate.post(this.dbURI.append("_compact").append(designDocumentId).toString(), "not_used", VOID_RESPONSE_HANDLER);
    }

    @Override
    public List<DocumentOperationResult> executeAllOrNothing(InputStream inputStream) {
        return this.executeBulk(inputStream, true);
    }

    @Override
    public List<DocumentOperationResult> executeBulk(InputStream inputStream) {
        return this.executeBulk(inputStream, false);
    }

    public List<DocumentOperationResult> executeBulk(InputStream inputStream, boolean allOrNothing) {
        return this.inputStreamBulkExecutor.executeBulk(inputStream, allOrNothing);
    }

    @Override
    public List<DocumentOperationResult> executeAllOrNothing(Collection<?> objects) {
        return this.executeBulk(objects, true);
    }

    @Override
    public List<DocumentOperationResult> executeBulk(Collection<?> objects) {
        return this.executeBulk(objects, false);
    }

    @Override
    public void addToBulkBuffer(Object o) {
        this.localBulkBuffer.addToBulkBuffer(o);
    }

    @Override
    public void clearBulkBuffer() {
        this.localBulkBuffer.clearBulkBuffer();
    }

    @Override
    public List<DocumentOperationResult> flushBulkBuffer() {
        return this.localBulkBuffer.flushBulkBuffer();
    }

    @Deprecated
    public void setJsonSerializer(JsonSerializer js) {
        Assert.notNull(js, "JsonSerializer may not be null");
        this.jsonSerializer = js;
    }

    protected String serializeToJson(Object o) {
        return this.jsonSerializer.toJson(o);
    }

    public List<DocumentOperationResult> executeBulk(Collection<?> objects, boolean allOrNothing) {
        return this.collectionBulkExecutor.executeBulk(objects, allOrNothing);
    }

    @Override
    public int getRevisionLimit() {
        return this.restTemplate.get(this.dbURI.append("_revs_limit").toString(), new StdResponseHandler<Integer>(){

            @Override
            public Integer success(HttpResponse hr) throws Exception {
                JsonNode rlimit = StdCouchDbConnector.this.objectMapper.readTree(hr.getContent());
                return rlimit.asInt();
            }
        });
    }

    @Override
    public void setRevisionLimit(int limit) {
        this.restTemplate.put(this.dbURI.append("_revs_limit").toString(), Integer.toString(limit), VOID_RESPONSE_HANDLER);
    }

    private InputStream fetchChangesAsStream(ChangesCommand cmd) {
        HttpResponse r = this.restTemplate.get(this.dbURI.append(cmd.toString()).toString());
        return r.getContent();
    }

    @Override
    public List<DocumentChange> changes(ChangesCommand cmd) {
        if (cmd.continuous) {
            throw new IllegalArgumentException("ChangesCommand may not declare continous = true while calling changes");
        }
        ChangesCommand actualCmd = new ChangesCommand.Builder().merge(cmd).continuous(false).build();
        ArrayList<DocumentChange> changes = new ArrayList<DocumentChange>();
        try {
            JsonNode node = this.objectMapper.readTree(this.fetchChangesAsStream(actualCmd));
            JsonNode results = node.findPath("results");
            for (JsonNode change : results) {
                changes.add(new StdDocumentChange(change));
            }
        }
        catch (IOException e) {
            throw Exceptions.propagate(e);
        }
        return changes;
    }

    @Override
    public StreamingChangesResult changesAsStream(ChangesCommand cmd) {
        if (cmd.continuous) {
            throw new IllegalArgumentException("ChangesCommand may not declare continous = true while calling changes");
        }
        ChangesCommand actualCmd = new ChangesCommand.Builder().merge(cmd).continuous(false).build();
        HttpResponse response = this.restTemplate.get(this.dbURI.append(actualCmd.toString()).toString());
        return new StreamingChangesResult(this.objectMapper, response);
    }

    @Override
    public ChangesFeed changesFeed(ChangesCommand cmd) {
        int heartbeat = cmd.heartbeat > 0 ? cmd.heartbeat : 9000;
        String since = cmd.since != null ? cmd.since : this.getDbInfo().getUpdateSeqAsString();
        ChangesCommand actualCmd = new ChangesCommand.Builder().merge(cmd).continuous(true).heartbeat(heartbeat).since(since).build();
        return new ContinuousChangesFeed(this.dbName, this.restTemplate.getUncached(this.dbURI.append(actualCmd.toString()).toString()));
    }

    @Override
    public String callUpdateHandler(String designDocID, String function, String docID) {
        return this.callUpdateHandler(designDocID, function, docID, null);
    }

    @Override
    public String callUpdateHandler(String designDocID, String function, String docID, Map<String, String> params) {
        Assert.hasText(designDocID, "designDocID may not be null or empty");
        Assert.hasText(function, "functionName may not be null or empty");
        Assert.hasText(docID, "docId may not be null or empty");
        UpdateHandlerRequest req = new UpdateHandlerRequest();
        req.dbPath(this.dbURI.toString()).designDocId(designDocID).functionName(function).docId(docID).params(params).buildRequestUri();
        return this.callUpdateHandler(req);
    }

    private String serializeUpdateHandlerRequestBody(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            return (String)o;
        }
        try {
            return this.objectMapper.writeValueAsString(o);
        }
        catch (Exception e) {
            throw Exceptions.propagate(e);
        }
    }

    @Override
    public String callUpdateHandler(UpdateHandlerRequest req) {
        Assert.hasText(req.getDesignDocId(), "designDocID may not be null or empty");
        Assert.hasText(req.getFunctionName(), "functionName may not be null or empty");
        Assert.hasText(req.getDocId(), "docId may not be null or empty");
        req.dbPath(this.dbURI.toString());
        return this.restTemplate.put(req.buildRequestUri(), this.serializeUpdateHandlerRequestBody(req.getBody()), new StdResponseHandler<String>(){

            @Override
            public String success(HttpResponse hr) throws JsonProcessingException, IOException {
                return IOUtils.toString((InputStream)hr.getContent(), (String)"UTF-8");
            }
        });
    }

    @Override
    public <T> T callUpdateHandler(final UpdateHandlerRequest req, final Class<T> c) {
        Assert.hasText(req.getDesignDocId(), "designDocID may not be null or empty");
        Assert.hasText(req.getFunctionName(), "functionName may not be null or empty");
        Assert.hasText(req.getDocId(), "docId may not be null or empty");
        req.dbPath(this.dbURI.toString());
        return this.restTemplate.put(req.buildRequestUri(), this.serializeUpdateHandlerRequestBody(req.getBody()), new StdResponseHandler<T>(){

            @Override
            public T success(HttpResponse hr) throws Exception {
                return StdCouchDbConnector.this.objectMapper.readValue(hr.getContent(), c);
            }

            @Override
            public T error(HttpResponse hr) {
                if (hr.getCode() == 409) {
                    throw new UpdateConflictException(req.getDocId(), "<Update Handler>");
                }
                return null;
            }
        });
    }

    @Override
    public void ensureFullCommit() {
        this.restTemplate.post(this.dbURI.append("_ensure_full_commit").toString(), "", new StdResponseHandler());
    }

    @Override
    public void updateMultipart(String id, InputStream stream, String boundary, long length, Options options) {
        this.assertDocIdHasValue(id);
        Assert.hasText(boundary);
        URI uri = this.dbURI.append(id);
        this.applyOptions(options, uri);
        String contentType = String.format("multipart/related; boundary=\"%s\"", boundary);
        this.restTemplate.put(uri.toString(), stream, contentType, length);
    }

    @Override
    public void update(String id, InputStream document, long length, Options options) {
        this.assertDocIdHasValue(id);
        URI uri = this.dbURI.append(id);
        this.applyOptions(options, uri);
        this.restTemplate.put(uri.toString(), document, "application/json", length);
    }

    private String securityPath() {
        return String.format("%s_security", this.dbURI);
    }
}

