/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.ektorp.CouchDbInstance;
import org.ektorp.DocumentOperationResult;
import org.ektorp.PurgeResult;
import org.ektorp.UpdateConflictException;
import org.ektorp.http.HttpResponse;
import org.ektorp.http.JacksonableEntity;
import org.ektorp.http.StdResponseHandler;
import org.ektorp.impl.EntityCollectionBulkExecutor;
import org.ektorp.impl.InputStreamBulkEntityBulkExecutor;
import org.ektorp.impl.ObjectMapperFactory;
import org.ektorp.impl.StdCouchDbConnector;
import org.ektorp.util.Assert;
import org.ektorp.util.Documents;

public class StreamedCouchDbConnector
extends StdCouchDbConnector {
    public StreamedCouchDbConnector(String databaseName, CouchDbInstance dbInstance) {
        super(databaseName, dbInstance);
        this.setCollectionBulkExecutor(new EntityCollectionBulkExecutor(this.dbURI, this.restTemplate, this.objectMapper));
        this.setInputStreamBulkExecutor(new InputStreamBulkEntityBulkExecutor(this.dbURI, this.restTemplate, this.objectMapper));
    }

    public StreamedCouchDbConnector(String databaseName, CouchDbInstance dbi, ObjectMapperFactory om) {
        super(databaseName, dbi, om);
        this.setCollectionBulkExecutor(new EntityCollectionBulkExecutor(this.dbURI, this.restTemplate, this.objectMapper));
        this.setInputStreamBulkExecutor(new InputStreamBulkEntityBulkExecutor(this.dbURI, this.restTemplate, this.objectMapper));
    }

    protected HttpEntity createHttpEntity(Object o) {
        return new JacksonableEntity(o, this.objectMapper);
    }

    @Override
    public void create(Object o) {
        DocumentOperationResult result;
        Assert.notNull(o, "Document may not be null");
        Assert.isTrue(Documents.isNew(o), "Object must be new");
        HttpEntity entity = this.createHttpEntity(o);
        String id = Documents.getId(o);
        if (id != null && id.length() != 0) {
            result = this.restTemplate.put(this.URIWithDocId(id), entity, this.revisionHandler);
        } else {
            result = this.restTemplate.post(this.dbURI.toString(), entity, this.revisionHandler);
            Documents.setId(o, result.getId());
        }
        Documents.setRevision(o, result.getRevision());
    }

    @Override
    public void create(String id, Object node) {
        this.assertDocIdHasValue(id);
        Assert.notNull(node, "node may not be null");
        HttpEntity entity = this.createHttpEntity(node);
        this.restTemplate.put(this.URIWithDocId(id), entity);
    }

    @Override
    public PurgeResult purge(Map<String, List<String>> revisionsToPurge) {
        HttpEntity entity = this.createHttpEntity(revisionsToPurge);
        return this.restTemplate.post(this.dbURI.append("_purge").toString(), entity, new StdResponseHandler<PurgeResult>(){

            @Override
            public PurgeResult success(HttpResponse hr) throws Exception {
                return (PurgeResult)StreamedCouchDbConnector.this.objectMapper.readValue(hr.getContent(), PurgeResult.class);
            }
        });
    }

    @Override
    public void update(final Object o) {
        Assert.notNull(o, "Document cannot be null");
        final String id = Documents.getId(o);
        this.assertDocIdHasValue(id);
        HttpEntity entity = this.createHttpEntity(o);
        this.restTemplate.put(this.dbURI.append(id).toString(), entity, new StdResponseHandler<Void>(){

            @Override
            public Void success(HttpResponse hr) throws Exception {
                JsonNode n = (JsonNode)StreamedCouchDbConnector.this.objectMapper.readValue(hr.getContent(), JsonNode.class);
                Documents.setRevision(o, n.get("rev").textValue());
                return null;
            }

            @Override
            public Void error(HttpResponse hr) {
                if (hr.getCode() == 409) {
                    throw new UpdateConflictException(id, Documents.getRevision(o));
                }
                return (Void)super.error(hr);
            }
        });
    }
}

