/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.ektorp.util.ClassHierarchyMap;

public class JSONComparator {
    private static final Map<Class<?>, ValueComparator> valueComparators = JSONComparator.createValueComparatorsMap();

    private static <T> Map<Class<?>, ValueComparator> createValueComparatorsMap() {
        ClassHierarchyMap valueComparators = new ClassHierarchyMap();
        valueComparators.put(Map.class, (ValueComparator<Map<String, ?>>)new MapComparator());
        valueComparators.put(List.class, (ValueComparator<Map<String, ?>>)new ListComparator());
        valueComparators.put(Object.class, (ValueComparator<Map<String, ?>>)new ObjectComparator());
        return valueComparators;
    }

    private JSONComparator() {
    }

    public static boolean areEqual(String jsonA, String jsonB) {
        return JSONComparator.areEqual(new StringReader(jsonA), new StringReader(jsonB));
    }

    public static <T> boolean areEqual(Reader jsonA, Reader jsonB) {
        ObjectMapper om = new ObjectMapper();
        Map mapA = null;
        try {
            mapA = (Map)om.readValue(jsonA, Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Map mapB = null;
        try {
            mapB = (Map)om.readValue(jsonB, Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return JSONComparator.areEquals(mapA, mapB);
    }

    private static <T> boolean areEquals(Map<String, T> mapA, Map<String, T> mapB) {
        ValueComparator valueComparator = valueComparators.get(Map.class);
        return valueComparator.equals(mapA, mapB);
    }

    private static boolean compareValue(Object aValue, Object bValue) {
        if (aValue == bValue) {
            return true;
        }
        if (bValue == null) {
            return false;
        }
        ValueComparator<Object> vp = JSONComparator.getComparator(aValue);
        return vp.equals(aValue, bValue);
    }

    private static <T> ValueComparator<T> getComparator(T aValue) {
        ValueComparator vp = valueComparators.get(aValue.getClass());
        if (vp == null) {
            throw new IllegalStateException(String.format("No value comparator found for class: %s", aValue.getClass()));
        }
        return vp;
    }

    private static class ListComparator
    implements ValueComparator<List> {
        private ListComparator() {
        }

        @Override
        public boolean equals(List aList, List bList) {
            if (aList.size() != bList.size()) {
                return false;
            }
            for (int i = 0; i < aList.size(); ++i) {
                if (JSONComparator.compareValue(aList.get(i), bList.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    private static class MapComparator
    implements ValueComparator<Map<String, ?>> {
        private MapComparator() {
        }

        @Override
        public boolean equals(Map<String, ?> aValueMap, Map<String, ?> bValueMap) {
            if (aValueMap.size() != bValueMap.size()) {
                return false;
            }
            for (Map.Entry<String, ?> entry : aValueMap.entrySet()) {
                Object bValue = bValueMap.get(entry.getKey());
                if (JSONComparator.compareValue(entry.getValue(), bValue)) continue;
                return false;
            }
            return true;
        }
    }

    private static class ObjectComparator
    implements ValueComparator<Object> {
        private ObjectComparator() {
        }

        @Override
        public boolean equals(Object a, Object b) {
            return a.equals(b);
        }
    }

    private static interface ValueComparator<T> {
        public boolean equals(T var1, T var2);
    }
}

