package org.elsfs.openai.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author zeng
 * @since 0.0.1
 */
@Data
public class CommonRequest implements Serializable {
    /**
     * optional
     * <p>
     * What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.
     * 使用什么样的采样温度，介于0和2之间。值越高（如0.8），输出越随机，而值越低（如0.2），输出就越集中，确定性更强。
     */
    private Float temperature;
    /**
     * optional
     * How many answers to generate for each question.
     * 每个问题要生成多少个答案。
     */
    private Integer n;
    /**
     * optional
     * *API将停止生成更多令牌的最多4个序列。返回的文本将不包含停止序列。
     */
    private List<String> stop;
    /**
     * optional
     * The maximum number of tokens allowed for the generated answer
     * 生成的答案允许的最大令牌数
     */
    @JsonProperty("max_tokens")
    private Integer maxTokens;

    /**
     * optional
     * Modify the likelihood of specified tokens appearing in the completion.
     * Accepts a json object that maps tokens (specified by their token ID in the GPT tokenizer) to an associated bias value from -100 to 100.
     * You can use this [tokenizer tool](/tokenizer?view=bpe) (which works for both GPT-2 and GPT-3) to convert text to token IDs. Mathematically, the bias is added to the logits generated by the model prior to sampling.
     * The exact effect will vary per model,
     * but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.
     * As an example, you can pass `50256": -100` to prevent the <|endoftext|> token from being generated.
     * 修改指定令牌出现在完成中的可能性。接受一个json对象，该对象将令牌（由GPT令牌化器中的令牌ID指定）映射到从-100到100的相关偏差值。您可以使用此[tokenizer工具]（/tokenizer？view=bpe）（适用于GPT-2和GPT-3）将文本转换为令牌ID。从数学上讲，在采样之前，将偏差添加到模型生成的logits中。每个模型的确切效果会有所不同，但-1到1之间的值应该会降低或增加选择的可能性；像-100或100这样的值应该导致对相关令牌的禁止或独占选择。例如，您可以传递“5025“：-100｝”以防止生成<|endoftext|>令牌。
     */
    @JsonProperty("logit_bias")
    private Map<String, Integer> logitBias;
    /**
     * optional
     * A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
     * 代表您的最终用户的唯一标识符，可以帮助OpenAI监控和检测滥用。[了解更多信息]（/docs/guides/安全最佳实践/最终用户id）。
     */
    private String user;
}
