package org.elsfs.openai.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * https://platform.openai.com/docs/api-reference/completions/create
 *
 * @author zeng
 * @since 0.0.1
 */
@Data
@Accessors(chain = true)
public class CreateCompletionRequest {
    /**
     * babbage
     * davinci
     * text-davinci-001
     * ada
     * text-ada-001
     * text-curie-001
     * curie-instruct-beta
     * davinci-instruct-beta
     * text-babbage-001
     * curie
     * text-davinci-003
     * text-davinci-002
     */
    private String model;
    /**
     * Array<any> | Array<number> | Array<string> | string;
     */
    private List<String> prompt;
    /**
     * The suffix that comes after a completion of inserted text.
     */
    private String suffix;
    @JsonProperty("max_tokens")
    private Integer maxTokens;

    private Number temperature;
    @JsonProperty("top_p")
    private Number topP;
    private Number n;
    private Boolean stream;
    private Number logprobs;
    /**
     * Echo back the prompt in addition to the completion
     */
    private Boolean echo;
    private List<String> stop;
    @JsonProperty("presence_penalty")
    private Number presencePenalty;
    @JsonProperty("frequency_penalty")
    private Number frequencyPenalty;
    /**
     * Generates `best_of` completions server-side and returns the \"best\" (the one with the highest log probability per token). Results cannot be streamed.  When used with `n`, `best_of` controls the number of candidate completions and `n` specifies how many to return – `best_of` must be greater than `n`.  **Note:** Because this parameter generates many completions, it can quickly consume your token quota. Use carefully and ensure that you have reasonable settings for `max_tokens` and `stop`.
     */
    @JsonProperty("best_of")
    private Number bestNf;
    /**
     * Modify the likelihood of specified tokens appearing in the completion.  Accepts a json object that maps tokens (specified by their token ID in the GPT tokenizer) to an associated bias value from -100 to 100. You can use this [tokenizer tool](/tokenizer?view=bpe) (which works for both GPT-2 and GPT-3) to convert text to token IDs. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.  As an example, you can pass `{\"50256\": -100}` to prevent the <|endoftext|> token from being generated.
     */
    @JsonProperty("logit_bias")
    private Map<String, String> logitBias;
    private String user;

}
