package org.elsfs.tool.core.tree;

import java.io.Serializable;

/**
 * 节点接口，提供节点相关的的方法定义
 *
 * @param <T> ID类型
 * @author zeng
 * @version 0.0.1
 */
public interface Node<T> extends Comparable<Node<T>>, Serializable {

  /**
   * 获取ID
   *
   * @return ID
   */
  T getId();

  /**
   * 设置ID
   *
   * @param id ID
   * @return this
   */
  Node<T> setId(T id);

  /**
   * 获取父节点ID
   *
   * @return 父节点ID
   */
  T getParentId();

  /**
   * 设置父节点ID
   *
   * @param parentId 父节点ID
   * @return this
   */
  Node<T> setParentId(T parentId);

  /**
   * 获取节点标签名称
   *
   * @return 节点标签名称
   */
  CharSequence getName();

  /**
   * 设置节点标签名称
   *
   * @param name 节点标签名称
   * @return this
   */
  Node<T> setName(CharSequence name);

  /**
   * 获取权重
   *
   * @return 权重
   */
  Comparable<?> getWeight();

  /**
   * 设置权重
   *
   * @param weight 权重
   * @return this
   */
  Node<T> setWeight(Comparable<?> weight);

  @SuppressWarnings({"unchecked", "rawtypes"})
  @Override
  default int compareTo(Node node) {
    if (null == node) {
      return 1;
    }
    final Comparable weight = this.getWeight();
    final Comparable weightOther = node.getWeight();
    return compare(weight, weightOther);
  }

  /**
   * {@code null}安全的对象比较
   *
   * @param <T> 被比较对象类型（必须实现Comparable接口）
   * @param c1  对象1，可以为{@code null}
   * @param c2  对象2，可以为{@code null}
   * @return 比较结果，如果c1 &lt; c2，返回数小于0，c1==c2返回0，c1 &gt; c2 大于0
   * @see java.util.Comparator#compare(Object, Object)
   */
  private static <T extends Comparable<? super T>> int compare(T c1, T c2) {
    if (c1 == c2) {
      return 0;
    } else if (c1 == null) {
      return -1;
    } else if (c2 == null) {
      return 1;
    }
    return c1.compareTo(c2);
  }
}
