package org.elsfs.tool.core.tree.parser;

import java.util.Map;
import org.elsfs.tool.core.tree.Tree;
import org.elsfs.tool.core.tree.TreeNode;
import org.elsfs.tool.core.util.CollectionUtils;

/**
 * 默认的简单转换器
 *
 * @param <T> ID类型
 * @author zeng
 * @version 0.0.1
 */
public class DefaultNodeParser<T> implements NodeParser<TreeNode<T>, T> {

  @Override
  public void parse(TreeNode<T> treeNode, Tree<T> tree) {
    tree.setId(treeNode.getId());
    tree.setParentId(treeNode.getParentId());
    tree.setWeight(treeNode.getWeight());
    tree.setName(treeNode.getName());

    // 扩展字段
    final Map<String, Object> extra = treeNode.getExtra();
    if (CollectionUtils.isNotEmpty(extra)) {
      extra.forEach(tree::putExtra);
    }
  }
}
