/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.core.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClassUtils {
    public static List<Field> getDeclaredFields(Class<?> classes) {
        return ClassUtils.getDeclaredFields(classes, true);
    }

    public static List<Field> getDeclaredFields(Class<?> classes, boolean isContainSuper) {
        Class<?> superclass;
        ArrayList<Field> fields = new ArrayList<Field>();
        if (classes == null) {
            return fields;
        }
        fields.addAll(Arrays.stream(classes.getDeclaredFields()).toList());
        if (isContainSuper && (superclass = classes.getSuperclass()) != null) {
            List<Field> list = ClassUtils.getDeclaredFields(superclass);
            if (list.isEmpty()) {
                return fields;
            }
            fields.addAll(list);
        }
        return fields;
    }

    public static Class<?> getSuperclass(Class<?> classes) {
        return classes == null ? null : classes.getSuperclass();
    }

    public static boolean isInterface(Class<?> classes) {
        return classes != null && classes.isInterface();
    }
}

