package org.elsfs.tool.core.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 这个工具主要是封装了一些反射的方法，使调用更加方便
 *
 * @author zeng
 * @since 0.0.1
 */
public class ClassUtils {

  /**
   * 获取声明的字段
   *
   * @param classes classes
   * @return 声明的字段
   */
  public static List<Field> getDeclaredFields(Class<?> classes) {
    return getDeclaredFields(classes, true);
  }

  /**
   * 获取声明的字段
   *
   * @param classes classes
   * @return Field
   */
  public static List<Field> getDeclaredFields(Class<?> classes, boolean isContainSuper) {
    List<Field> fields = new ArrayList<>();
    if (classes == null) {
      return fields;
    }
    fields.addAll(Arrays.stream(classes.getDeclaredFields()).toList());
    if (isContainSuper) {
      Class<?> superclass = classes.getSuperclass();
      if (superclass != null) {
        List<Field> list = getDeclaredFields(superclass);
        if (list.isEmpty()) {
          return fields;
        }
        fields.addAll(list);
      }
    }
    return fields;
  }

  /**
   * 获取 继承的class
   *
   * @param classes class
   * @return {@code null} 或者继承的class
   */
  public static Class<?> getSuperclass(Class<?> classes) {
    return classes == null ? null : classes.getSuperclass();
  }

  /**
   * 判断是否接口
   *
   * @param classes classes
   * @return true 是
   */
  public static boolean isInterface(Class<?> classes) {
    return classes != null && classes.isInterface();
  }
}
