package org.elsfs.tool.core.tree.parser;

import org.elsfs.tool.core.tree.Tree;

/**
 * 树节点解析器 可以参考{@link DefaultNodeParser}
 *
 * @param <T> 转换的实体 为数据源里的对象类型
 * @param <E> 节点
 * @author zeng
 * @version 0.0.1
 */
@FunctionalInterface
public interface NodeParser<T, E> {

  /**
   * tree 远数据映射
   *
   * @param object 源数据实体
   * @param treeNode 树节点实体
   */
  void parse(T object, Tree<E> treeNode);
}
