/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.core.text;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.elsfs.tool.core.text.ArrayUtils;
import org.elsfs.tool.core.text.StringUtils;

public class StrUtils
extends StringUtils {
    public static String utf8Str(Object obj) {
        return StrUtils.str(obj, StandardCharsets.UTF_8);
    }

    @Deprecated
    public static String str(Object obj, String charsetName) {
        return StrUtils.str(obj, Charset.forName(charsetName));
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StrUtils.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StrUtils.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StrUtils.str((ByteBuffer)obj, charset);
        }
        if (ArrayUtils.isArray(obj)) {
            return ArrayUtils.toString(obj);
        }
        return obj.toString();
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StrUtils.str(bytes, charset);
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }
}

