/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.core.tree;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elsfs.tool.core.tree.Tree;
import org.elsfs.tool.core.tree.TreeNodeConfig;
import org.elsfs.tool.core.tree.parser.NodeParser;
import org.elsfs.tool.core.util.CollectionUtils;

public class TreeBuilder<E> {
    private static final long serialVersionUID = 1L;
    private final Tree<E> root;
    private final Map<E, Tree<E>> idTreeMap;
    private boolean isBuild;

    public static <T> TreeBuilder<T> of(T rootId) {
        return TreeBuilder.of(rootId, null);
    }

    public static <T> TreeBuilder<T> of(T rootId, TreeNodeConfig config) {
        return new TreeBuilder<T>(rootId, config);
    }

    public TreeBuilder(E rootId, TreeNodeConfig config) {
        this.root = new Tree(config);
        this.root.setId((Object)rootId);
        this.idTreeMap = new LinkedHashMap<E, Tree<E>>();
    }

    public TreeBuilder<E> setId(E id) {
        this.root.setId((Object)id);
        return this;
    }

    public TreeBuilder<E> setParentId(E parentId) {
        this.root.setParentId((Object)parentId);
        return this;
    }

    public TreeBuilder<E> setName(CharSequence name) {
        this.root.setName(name);
        return this;
    }

    public TreeBuilder<E> setWeight(Comparable<?> weight) {
        this.root.setWeight((Comparable)weight);
        return this;
    }

    public TreeBuilder<E> putExtra(String key, Object value) {
        Objects.requireNonNull(key, "Key must be not empty !");
        this.root.put(key, value);
        return this;
    }

    public TreeBuilder<E> append(Map<E, Tree<E>> map) {
        this.checkBuilt();
        this.idTreeMap.putAll(map);
        return this;
    }

    public TreeBuilder<E> append(Iterable<Tree<E>> trees) {
        this.checkBuilt();
        for (Tree<E> tree : trees) {
            this.idTreeMap.put(tree.getId(), tree);
        }
        return this;
    }

    public <T> TreeBuilder<E> append(List<T> list, NodeParser<T, E> nodeParser) {
        return this.append(list, null, nodeParser);
    }

    public <T> TreeBuilder<E> append(List<T> list, E rootId, NodeParser<T, E> nodeParser) {
        this.checkBuilt();
        TreeNodeConfig config = this.root.getConfig();
        LinkedHashMap map = new LinkedHashMap(list.size(), 1.0f);
        for (T t : list) {
            Tree node = new Tree(config);
            nodeParser.parse(t, node);
            if (null != rootId && !Objects.equals(rootId.getClass(), node.getId().getClass())) {
                throw new IllegalArgumentException("rootId type is node.getId().getClass()!");
            }
            map.put(node.getId(), node);
        }
        return this.append(map);
    }

    public TreeBuilder<E> reset() {
        this.idTreeMap.clear();
        this.root.setChildren(null);
        this.isBuild = false;
        return this;
    }

    public Tree<E> build() {
        this.checkBuilt();
        this.buildFromMap();
        this.cutTree();
        this.isBuild = true;
        this.idTreeMap.clear();
        return this.root;
    }

    public List<Tree<E>> buildList() {
        if (this.isBuild) {
            return this.root.getChildren();
        }
        return this.build().getChildren();
    }

    private static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedHashMap result = new LinkedHashMap();
        Comparator entryComparator = Map.Entry.comparingByValue();
        map.entrySet().stream().sorted(entryComparator).forEachOrdered(e -> result.put(e.getKey(), (Comparable)e.getValue()));
        return result;
    }

    private void buildFromMap() {
        if (CollectionUtils.isEmpty(this.idTreeMap)) {
            return;
        }
        Map<E, Tree<E>> eTreeMap = TreeBuilder.sortByValue(this.idTreeMap);
        for (Tree<E> node : eTreeMap.values()) {
            if (null == node) continue;
            E parentId = node.getParentId();
            if (Objects.equals(this.root.getId(), parentId)) {
                this.root.addChildren(node);
                continue;
            }
            Tree<E> parentNode = eTreeMap.get(parentId);
            if (null == parentNode) continue;
            parentNode.addChildren(node);
        }
    }

    private void cutTree() {
        TreeNodeConfig config = this.root.getConfig();
        Integer deep = config.getDeep();
        if (null == deep || deep < 0) {
            return;
        }
        this.cutTree(this.root, 0, deep);
    }

    private void cutTree(Tree<E> tree, int currentDepp, int maxDeep) {
        if (null == tree) {
            return;
        }
        if (currentDepp == maxDeep) {
            tree.setChildren(null);
            return;
        }
        List<Tree<E>> children = tree.getChildren();
        if (CollectionUtils.isNotEmpty(children)) {
            for (Tree<E> child : children) {
                this.cutTree(child, currentDepp + 1, maxDeep);
            }
        }
    }

    private void checkBuilt() {
        if (this.isBuild) {
            throw new RuntimeException("Current tree has been built.");
        }
    }
}

