package org.elsfs.tool.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 这个工具主要是封装了一些反射的方法，使调用更加方便
 *
 * @author zeng
 * @since 0.0.1
 */
public class ClassUtils {

  /**
   * 获取声明的字段
   *
   * @param classes classes
   * @return 声明的字段
   */
  public static ArrayList<Field> getDeclaredFields(Class<?> classes) {
    return getDeclaredFields(classes, true);
  }

  /**
   * 获取声明的字段
   *
   * @param classes classes
   * @return Field
   */
  public static ArrayList<Field> getDeclaredFields(Class<?> classes, boolean isContainSuper) {
    ArrayList<Field> fields = new ArrayList<>();
    if (classes == null) {
      return fields;
    }
    fields.addAll(Arrays.stream(classes.getDeclaredFields()).toList());
    if (isContainSuper) {
      Class<?> superclass = classes.getSuperclass();
      if (superclass != null) {
        List<Field> list = getDeclaredFields(superclass);
        if (list.isEmpty()) {
          return fields;
        }
        fields.addAll(list);
      }
    }
    return fields;
  }

  /**
   * 获取 继承的class
   *
   * @param classes class
   * @return {@code null} 或者继承的class
   */
  public static Class<?> getSuperclass(Class<?> classes) {
    return classes == null ? null : classes.getSuperclass();
  }

  /**
   * 判断是否接口
   *
   * @param classes classes
   * @return true 是
   */
  public static boolean isInterface(Class<?> classes) {
    return classes != null && classes.isInterface();
  }

  /**
   * 获取泛型class
   *
   * @param type type
   * @return class
   */
  public static Class<?>[] getClassOfParameterizedType(Type type) {
    // 是否带泛型
    if (type instanceof ParameterizedType pt) {
      Type[] subTypes = pt.getActualTypeArguments();
      Class<?>[] classes = new Class[subTypes.length];
      for (int i = 0; i < subTypes.length; i++) {
        // 获取泛型类型
        Class<?> clazz = (Class<?>) ((ParameterizedType) subTypes[i]).getRawType();
        classes[i] = clazz;
      }
      return classes;
    }
    return null;
  }

  /**
   * 获取泛型class
   *
   * @param type type
   * @return class
   */
  public static Class<?> getClassOfParameterizedType(Type type, int index) {
    Class<?>[] classes = getClassOfParameterizedType(type);
    if (classes == null || classes.length == 0 || classes.length < index) {
      return null;
    }
    return classes[index];
  }
}
