/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.core.text;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;

public class ArrayUtils {
    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isArray(Object obj) {
        return null != obj && obj.getClass().isArray();
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (ArrayUtils.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return obj.toString();
    }

    @SafeVarargs
    public static <T> T[] append(T[] buffer, T ... newElements) {
        if (ArrayUtils.isEmpty(buffer)) {
            return newElements;
        }
        return ArrayUtils.insert(buffer, buffer.length, newElements);
    }

    public static <T> T[] insert(T[] buffer, int index, T ... newElements) {
        return (Object[])ArrayUtils.insert(buffer, index, newElements);
    }

    public static <T> Object insert(Object array, int index, T ... newElements) {
        if (ArrayUtils.isEmpty(newElements)) {
            return array;
        }
        if (Objects.isNull(array)) {
            return newElements;
        }
        int len = ArrayUtils.length(array);
        if (index < 0) {
            index = index % len + len;
        }
        Class<?> originComponentType = array.getClass().getComponentType();
        T[] newEleArr = newElements;
        if (originComponentType.isPrimitive()) {
            // empty if block
        }
        Object result = Array.newInstance(originComponentType, Math.max(len, index) + newElements.length);
        System.arraycopy(array, 0, result, 0, Math.min(len, index));
        System.arraycopy(newEleArr, 0, result, index, newElements.length);
        if (index < len) {
            System.arraycopy(array, index, result, index + newElements.length, len - index);
        }
        return result;
    }

    public static int length(Object array) throws IllegalArgumentException {
        if (null == array) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static boolean isNotEmpty(Object[] var) {
        return var != null && var.length > 0;
    }
}

