package org.elsfs.tool.sql.mybatisplus.update;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.elsfs.tool.core.exception.SqlException;
import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrPool;
import org.elsfs.tool.sql.conditions.update.UpdateCondition;
import org.elsfs.tool.sql.mybatisplus.conditions.AbstractMybatisPlusCondition;
import org.elsfs.tool.sql.mybatisplus.mapper.ElsfsMapper;

/**
 * MybatisPlus更新动作实现
 *
 * @author zeng
 * @since 0.0.3
 */
public class UpdateMybatisPlusCondition<E>
    extends AbstractMybatisPlusCondition<UpdateCondition<Integer>, E>
    implements UpdateCondition<Integer> {
  private final ElsfsMapper<E> elsfsMapper;

  public UpdateMybatisPlusCondition(UpdateWrapper<E> updateWrapper, ElsfsMapper<E> elsfsMapper) {
    super(updateWrapper);
    this.elsfsMapper = elsfsMapper;
  }

  /**
   * 获取Wrapper对象，用于高级查询
   *
   * @return Wrapper查询对象
   */
  @SuppressWarnings("unchecked")
  protected UpdateWrapper<E> getWrapper() {
    return (UpdateWrapper<E>) this.wrapper;
  }

  /**
   * 解析字段枚举名称
   *
   * @param field 字段枚举
   * @return 字段名称
   */
  @Override
  public String resolveFieldName(Enum<?> field) {
    return NamingCase.toUnderlineCase(field.name());
  }

  /**
   * 解析字段枚举名称
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @return 字段名称
   */
  @Override
  public String resolveFieldName(String tableAlias, Enum<?> field) {
    return tableAlias + StrPool.DOT + field.name();
  }

  /**
   * 获取操作Action实例
   *
   * @param wrapper 条件Wrapper对象
   * @return Action实例
   */
  @Override
  protected UpdateMybatisPlusCondition<E> instance(Wrapper<E> wrapper) {
    if (wrapper instanceof UpdateWrapper<E> updateWrapper) {
      return new UpdateMybatisPlusCondition<>(updateWrapper, elsfsMapper);
    }
    return new UpdateMybatisPlusCondition<>(null, elsfsMapper);
  }

  /**
   * 设置值
   *
   * @param condition 是否应用设置
   * @param field 表字段名
   * @param value 值
   * @return 具体实现
   */
  @Override
  public UpdateCondition<Integer> set(boolean condition, String field, Object value) {
    this.getWrapper().set(condition, field, value);
    return childThis;
  }

  /**
   * 设置SQL
   *
   * @param condition 是否应用设置SQL
   * @param sqlValue SQL片段：name=xxx
   * @return 具体实现
   */
  @Override
  public UpdateCondition<Integer> setSql(boolean condition, String sqlValue) {
    this.getWrapper().setSql(condition, sqlValue);
    return childThis;
  }

  /**
   * Gets a result.
   *
   * @return a result
   */
  @Override
  public Integer get() {
    if (this.elsfsMapper == null) {
      throw new SqlException("嵌套查询条件设置Action不支持execute操作");
    }
    return this.elsfsMapper.update(null, this.wrapper);
  }
}
