/*
 * Decompiled with CFR 0.152.
 */
package org.elsfs.tool.sql.mybatisplus.conditions;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.interfaces.Join;
import com.baomidou.mybatisplus.core.conditions.interfaces.Nested;
import java.util.Collection;
import java.util.function.Consumer;
import org.elsfs.tool.core.text.NamingCase;
import org.elsfs.tool.core.text.StrFormatter;
import org.elsfs.tool.sql.conditions.Condition;

public abstract class AbstractMybatisPlusCondition<Children, E>
implements Condition<Children> {
    protected final Children childThis = this;
    protected final AbstractWrapper<E, String, ?> wrapper;

    protected AbstractMybatisPlusCondition(AbstractWrapper<E, String, ?> wrapper) {
        this.wrapper = wrapper;
    }

    protected abstract Children instance(Wrapper<E> var1);

    protected Join<?> getJoin() {
        return this.wrapper;
    }

    protected Nested<Wrapper<E>, Wrapper<E>> getNested() {
        return this.wrapper;
    }

    protected String convertToDbFieldName(String field) {
        return NamingCase.toUnderlineCase((CharSequence)field);
    }

    public Children eq(boolean condition, String field, Object value) {
        this.wrapper.eq(condition, (Object)this.convertToDbFieldName(field), value);
        return this.childThis;
    }

    public Children eqSql(boolean condition, String field, String sqlValue) {
        if (condition) {
            this.wrapper.apply(StrFormatter.format((String)"{}=({})", (Object[])new Object[]{this.convertToDbFieldName(field), sqlValue}), new Object[0]);
        }
        return this.childThis;
    }

    public Children and(boolean condition, Consumer<Children> consumer) {
        if (condition) {
            this.getNested().and(wp -> {
                Children child = this.instance((Wrapper<E>)wp);
                consumer.accept(child);
            });
        }
        return this.childThis;
    }

    public Children apply(boolean condition, Consumer<Children> actionConsumer) {
        if (condition) {
            actionConsumer.accept(this.childThis);
        }
        return this.childThis;
    }

    public Children between(boolean condition, String field, Object leftValue, Object rightValue) {
        if (condition) {
            this.wrapper.between((Object)this.convertToDbFieldName(field), leftValue, rightValue);
        }
        return this.childThis;
    }

    public Children exists(boolean condition, String sqlValue, Object ... values) {
        this.getJoin().exists(condition, sqlValue, values);
        return this.childThis;
    }

    public Children expression(boolean condition, String sqlValue, Object ... values) {
        this.getJoin().apply(condition, sqlValue, values);
        return this.childThis;
    }

    public Children ge(boolean condition, String field, Object value) {
        this.wrapper.ge(condition, (Object)this.convertToDbFieldName(field), value);
        return this.childThis;
    }

    public Children geSql(boolean condition, String field, String sqlValue) {
        this.wrapper.geSql(condition, (Object)this.convertToDbFieldName(field), sqlValue);
        return this.childThis;
    }

    public Children gt(boolean condition, String field, Object value) {
        this.wrapper.gt(condition, (Object)this.convertToDbFieldName(field), value);
        return this.childThis;
    }

    public Children in(boolean condition, String field, Collection<?> values) {
        this.wrapper.in(condition, (Object)this.convertToDbFieldName(field), values);
        return this.childThis;
    }

    public Children in(boolean condition, String field, Object ... values) {
        this.wrapper.in(condition, (Object)this.convertToDbFieldName(field), values);
        return this.childThis;
    }

    public Children isNotNull(boolean condition, String field) {
        this.wrapper.isNotNull(condition, (Object)this.convertToDbFieldName(field));
        return this.childThis;
    }

    public Children inSql(boolean condition, String field, String sqlValue) {
        this.wrapper.inSql(condition, (Object)this.convertToDbFieldName(field), sqlValue);
        return this.childThis;
    }

    public Children gtSql(boolean condition, String field, String sqlValue) {
        this.wrapper.gtSql(condition, (Object)this.convertToDbFieldName(field), sqlValue);
        return this.childThis;
    }

    public Children le(boolean condition, String field, Object value) {
        this.wrapper.le(condition, (Object)this.convertToDbFieldName(field), value);
        return this.childThis;
    }

    public Children leSql(boolean condition, String field, String sqlValue) {
        this.wrapper.leSql(condition, (Object)this.convertToDbFieldName(field), sqlValue);
        return this.childThis;
    }

    public Children like(boolean condition, String field, Object value) {
        this.wrapper.like(condition, (Object)this.convertToDbFieldName(field), value);
        return this.childThis;
    }

    public Children likeLeft(boolean condition, String field, Object value) {
        this.wrapper.likeLeft(condition, (Object)this.convertToDbFieldName(field), value);
        return this.childThis;
    }

    public Children likeRight(boolean condition, String field, Object value) {
        this.wrapper.likeRight(condition, (Object)this.convertToDbFieldName(field), value);
        return this.childThis;
    }

    public Children lt(boolean condition, String field, Object value) {
        this.wrapper.lt(condition, (Object)this.convertToDbFieldName(field), value);
        return this.childThis;
    }

    public Children ltSql(boolean condition, String field, String sqlValue) {
        this.wrapper.ltSql(condition, (Object)this.convertToDbFieldName(field), sqlValue);
        return this.childThis;
    }

    public Children ne(boolean condition, String field, Object value) {
        this.wrapper.ne(condition, (Object)this.convertToDbFieldName(field), value);
        return this.childThis;
    }

    public Children nested(boolean condition, Consumer<Children> consumer) {
        if (condition) {
            this.getNested().nested(wp -> {
                Children child = this.instance((Wrapper<E>)wp);
                consumer.accept(child);
            });
        }
        return this.childThis;
    }

    public Children notBetween(boolean condition, String field, Object leftValue, Object rightValue) {
        this.wrapper.notBetween(condition, (Object)this.convertToDbFieldName(field), leftValue, rightValue);
        return this.childThis;
    }

    public Children isNull(boolean condition, String field) {
        this.wrapper.isNull(condition, (Object)this.convertToDbFieldName(field));
        return this.childThis;
    }

    public Children notExists(boolean condition, String sqlValue, Object ... values) {
        this.getJoin().notExists(condition, sqlValue, values);
        return this.childThis;
    }

    public Children notIn(boolean condition, String field, Collection<?> values) {
        this.wrapper.notIn(condition, (Object)this.convertToDbFieldName(field), values);
        return this.childThis;
    }

    public Children notIn(boolean condition, String field, Object ... values) {
        this.wrapper.notIn(condition, (Object)this.convertToDbFieldName(field), values);
        return this.childThis;
    }

    public Children notInSql(boolean condition, String field, String sqlValue) {
        this.wrapper.notInSql(condition, (Object)this.convertToDbFieldName(field), sqlValue);
        return this.childThis;
    }

    public Children notLike(boolean condition, String field, Object value) {
        this.wrapper.notLike(condition, (Object)this.convertToDbFieldName(field), value);
        return this.childThis;
    }

    public Children or(boolean condition) {
        if (condition) {
            this.or();
        }
        return this.childThis;
    }

    public Children or() {
        this.getJoin().or();
        return this.childThis;
    }

    public Children or(boolean condition, Consumer<Children> consumer) {
        if (condition) {
            return (Children)this.or(consumer);
        }
        return this.childThis;
    }
}

