package org.elsfs.tool.sql.mybatisplus;

import java.util.Collection;
import java.util.function.Consumer;
import org.elsfs.tool.sql.singular.facade.ConditionOperations;

/**
 * 抽象条件操作实现
 *
 * @param <C> 子类实现
 * @author zeng
 * @since 0.0.4
 */
public abstract class AbstractConditionOperations<C> implements ConditionOperations<C> {

  /** 子类引用 */
  @SuppressWarnings("unchecked")
  protected final C childThis = (C) this;

  /**
   * 等于
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C eq(boolean condition, String field, Object value) {
    if (condition) {
      return this.eq(field, value);
    }

    return this.childThis;
  }

  /**
   * 等于
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C eq(boolean condition, Enum<?> field, Object value) {
    if (condition) {
      return this.eq(field, value);
    }

    return this.childThis;
  }

  /**
   * 等于
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C eq(boolean condition, String tableAlias, Enum<?> field, Object value) {
    if (condition) {
      return this.eq(tableAlias, field, value);
    }

    return this.childThis;
  }

  /**
   * 不等于
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C ne(boolean condition, String field, Object value) {
    if (condition) {
      return this.ne(field, value);
    }

    return this.childThis;
  }

  /**
   * 不等于
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C ne(boolean condition, Enum<?> field, Object value) {
    if (condition) {
      return this.ne(field, value);
    }

    return this.childThis;
  }

  /**
   * 不等于
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C ne(boolean condition, String tableAlias, Enum<?> field, Object value) {
    if (condition) {
      return this.ne(tableAlias, field, value);
    }

    return this.childThis;
  }

  /**
   * 大于
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C gt(boolean condition, String field, Object value) {
    if (condition) {
      return this.gt(field, value);
    }

    return this.childThis;
  }

  /**
   * 大于
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C gt(boolean condition, Enum<?> field, Object value) {
    if (condition) {
      return this.gt(field, value);
    }

    return this.childThis;
  }

  /**
   * 大于
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C gt(boolean condition, String tableAlias, Enum<?> field, Object value) {
    if (condition) {
      return this.gt(tableAlias, field, value);
    }

    return this.childThis;
  }

  /**
   * 大于等于
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C ge(boolean condition, String field, Object value) {
    if (condition) {
      return this.ge(field, value);
    }

    return this.childThis;
  }

  /**
   * 大于等于
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C ge(boolean condition, Enum<?> field, Object value) {
    if (condition) {
      return this.ge(field, value);
    }

    return this.childThis;
  }

  /**
   * 大于等于
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C ge(boolean condition, String tableAlias, Enum<?> field, Object value) {
    if (condition) {
      return this.ge(tableAlias, field, value);
    }

    return this.childThis;
  }

  /**
   * 小于
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C lt(boolean condition, String field, Object value) {
    if (condition) {
      return this.lt(field, value);
    }

    return this.childThis;
  }

  /**
   * 小于
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C lt(boolean condition, Enum<?> field, Object value) {
    if (condition) {
      return this.lt(field, value);
    }

    return this.childThis;
  }

  /**
   * 小于
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C lt(boolean condition, String tableAlias, Enum<?> field, Object value) {
    if (condition) {
      return this.lt(tableAlias, field, value);
    }

    return this.childThis;
  }

  /**
   * 小于等于
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C le(boolean condition, String field, Object value) {
    if (condition) {
      return this.le(field, value);
    }

    return this.childThis;
  }

  /**
   * 小于等于
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C le(boolean condition, Enum<?> field, Object value) {
    if (condition) {
      return this.le(field, value);
    }

    return this.childThis;
  }

  /**
   * 小于等于
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C le(boolean condition, String tableAlias, Enum<?> field, Object value) {
    if (condition) {
      return this.le(tableAlias, field, value);
    }

    return this.childThis;
  }

  /**
   * 字段 = ( sql语句 )
   *
   * <p>例1: eqSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  @Override
  public C eqSql(boolean condition, String field, String sqlValue) {
    if (condition) {
      return this.eqSql(field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 = ( sql语句 )
   *
   * <p>例1: eqSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  @Override
  public C eqSql(boolean condition, Enum<?> field, String sqlValue) {
    if (condition) {
      return this.eqSql(field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 = ( sql语句 )
   *
   * <p>例1: eqSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  @Override
  public C eqSql(boolean condition, String tableAlias, Enum<?> field, String sqlValue) {
    if (condition) {
      return this.eqSql(tableAlias, field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 范围
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  @Override
  public C between(boolean condition, String field, Object leftValue, Object rightValue) {
    if (condition) {
      return this.between(field, leftValue, rightValue);
    }

    return this.childThis;
  }

  /**
   * 范围
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  @Override
  public C between(boolean condition, Enum<?> field, Object leftValue, Object rightValue) {
    if (condition) {
      return this.between(field, leftValue, rightValue);
    }

    return this.childThis;
  }

  /**
   * 范围
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  @Override
  public C between(
      boolean condition, String tableAlias, Enum<?> field, Object leftValue, Object rightValue) {
    if (condition) {
      return this.between(tableAlias, field, leftValue, rightValue);
    }

    return this.childThis;
  }

  /**
   * 不在范围
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  @Override
  public C notBetween(boolean condition, String field, Object leftValue, Object rightValue) {
    if (condition) {
      return this.notBetween(field, leftValue, rightValue);
    }

    return this.childThis;
  }

  /**
   * 不在范围
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  @Override
  public C notBetween(boolean condition, Enum<?> field, Object leftValue, Object rightValue) {
    if (condition) {
      return this.notBetween(field, leftValue, rightValue);
    }

    return this.childThis;
  }

  /**
   * 不在范围
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param leftValue 左值
   * @param rightValue 右值
   * @return 具体实现
   */
  @Override
  public C notBetween(
      boolean condition, String tableAlias, Enum<?> field, Object leftValue, Object rightValue) {
    if (condition) {
      return this.notBetween(tableAlias, field, leftValue, rightValue);
    }

    return this.childThis;
  }

  /**
   * 模糊匹配
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C like(boolean condition, String field, Object value) {
    if (condition) {
      return this.like(field, value);
    }

    return this.childThis;
  }

  /**
   * 模糊匹配
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C like(boolean condition, Enum<?> field, Object value) {
    if (condition) {
      return this.like(field, value);
    }

    return this.childThis;
  }

  /**
   * 模糊匹配
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C like(boolean condition, String tableAlias, Enum<?> field, Object value) {
    if (condition) {
      return this.like(tableAlias, field, value);
    }

    return this.childThis;
  }

  /**
   * 非模糊匹配
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C notLike(boolean condition, String field, Object value) {
    if (condition) {
      return this.notLike(field, value);
    }

    return this.childThis;
  }

  /**
   * 非模糊匹配
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C notLike(boolean condition, Enum<?> field, Object value) {
    if (condition) {
      return this.notLike(field, value);
    }

    return this.childThis;
  }

  /**
   * 非模糊匹配
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C notLike(boolean condition, String tableAlias, Enum<?> field, Object value) {
    if (condition) {
      return this.notLike(tableAlias, field, value);
    }

    return this.childThis;
  }

  /**
   * 左模糊匹配
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C likeLeft(boolean condition, String field, Object value) {
    if (condition) {
      return this.likeLeft(field, value);
    }

    return this.childThis;
  }

  /**
   * 左模糊匹配
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C likeLeft(boolean condition, Enum<?> field, Object value) {
    if (condition) {
      return this.likeLeft(field, value);
    }

    return this.childThis;
  }

  /**
   * 左模糊匹配
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C likeLeft(boolean condition, String tableAlias, Enum<?> field, Object value) {
    if (condition) {
      this.likeLeft(tableAlias, field, value);
    }

    return this.childThis;
  }

  /**
   * 右模糊匹配
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C likeRight(boolean condition, String field, Object value) {
    if (condition) {
      return this.likeRight(field, value);
    }

    return this.childThis;
  }

  /**
   * 右模糊匹配
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C likeRight(boolean condition, Enum<?> field, Object value) {
    if (condition) {
      return this.likeRight(field, value);
    }

    return this.childThis;
  }

  /**
   * 右模糊匹配
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param value 值
   * @return 具体实现
   */
  @Override
  public C likeRight(boolean condition, String tableAlias, Enum<?> field, Object value) {
    if (condition) {
      return this.likeRight(tableAlias, field, value);
    }

    return this.childThis;
  }

  /**
   * 范围匹配
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param values 值集合
   * @return 具体实现
   */
  @Override
  public C in(boolean condition, String field, Collection<?> values) {
    if (condition) {
      return this.in(field, values);
    }

    return this.childThis;
  }

  /**
   * 范围匹配
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param values 值集合
   * @return 具体实现
   */
  @Override
  public C in(boolean condition, Enum<?> field, Collection<?> values) {
    if (condition) {
      return this.in(field, values);
    }

    return this.childThis;
  }

  /**
   * 范围匹配
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param values 值集合
   * @return 具体实现
   */
  @Override
  public C in(boolean condition, String tableAlias, Enum<?> field, Collection<?> values) {
    if (condition) {
      return this.in(tableAlias, field, values);
    }

    return this.childThis;
  }

  /**
   * 范围匹配
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param values 值数组
   * @return 具体实现
   */
  @Override
  public C in(boolean condition, String field, Object... values) {
    if (condition) {
      return this.in(field, values);
    }

    return this.childThis;
  }

  /**
   * 范围匹配
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param values 值数组
   * @return 具体实现
   */
  @Override
  public C in(boolean condition, Enum<?> field, Object... values) {
    if (condition) {
      return this.in(field, values);
    }

    return this.childThis;
  }

  /**
   * 范围匹配
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param values 值数组
   * @return 具体实现
   */
  @Override
  public C in(boolean condition, String tableAlias, Enum<?> field, Object... values) {
    if (condition) {
      return this.in(tableAlias, field, values);
    }

    return this.childThis;
  }

  /**
   * 范围不匹配
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param values 值集合
   * @return 具体实现
   */
  @Override
  public C notIn(boolean condition, String field, Collection<?> values) {
    if (condition) {
      return this.notIn(field, values);
    }

    return this.childThis;
  }

  /**
   * 范围不匹配
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param values 值集合
   * @return 具体实现
   */
  @Override
  public C notIn(boolean condition, Enum<?> field, Collection<?> values) {
    if (condition) {
      return this.notIn(field, values);
    }

    return this.childThis;
  }

  /**
   * 范围不匹配
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param values 值集合
   * @return 具体实现
   */
  @Override
  public C notIn(boolean condition, String tableAlias, Enum<?> field, Collection<?> values) {
    if (condition) {
      return this.notIn(tableAlias, field, values);
    }

    return this.childThis;
  }

  /**
   * 范围不匹配
   *
   * @param condition 是否应用条件
   * @param field 字段名
   * @param values 值数组
   * @return 具体实现
   */
  @Override
  public C notIn(boolean condition, String field, Object... values) {
    if (condition) {
      return this.notIn(field, values);
    }

    return this.childThis;
  }

  /**
   * 范围不匹配
   *
   * @param condition 是否应用条件
   * @param field 字段枚举
   * @param values 值数组
   * @return 具体实现
   */
  @Override
  public C notIn(boolean condition, Enum<?> field, Object... values) {
    if (condition) {
      return this.notIn(field, values);
    }

    return this.childThis;
  }

  /**
   * 范围不匹配
   *
   * @param condition 是否应用条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param values 值数组
   * @return 具体实现
   */
  @Override
  public C notIn(boolean condition, String tableAlias, Enum<?> field, Object... values) {
    if (condition) {
      return this.notIn(tableAlias, field, values);
    }

    return this.childThis;
  }

  /**
   * 字段 &gt; ( sql语句 )
   *
   * <p>例1: gtSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: gtSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  @Override
  public C gtSql(boolean condition, String field, String sqlValue) {
    if (condition) {
      return this.gtSql(field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 &gt; ( sql语句 )
   *
   * <p>例1: gtSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: gtSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  @Override
  public C gtSql(boolean condition, Enum<?> field, String sqlValue) {
    if (condition) {
      return this.gtSql(field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 &gt; ( sql语句 )
   *
   * <p>例1: gtSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: gtSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  @Override
  public C gtSql(boolean condition, String tableAlias, Enum<?> field, String sqlValue) {
    if (condition) {
      return this.gtSql(tableAlias, field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 >= ( sql语句 )
   *
   * <p>例1: geSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  @Override
  public C geSql(boolean condition, String field, String sqlValue) {
    if (condition) {
      return this.geSql(field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 >= ( sql语句 )
   *
   * <p>例1: geSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  @Override
  public C geSql(boolean condition, Enum<?> field, String sqlValue) {
    if (condition) {
      return this.geSql(field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 >= ( sql语句 )
   *
   * <p>例1: geSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  @Override
  public C geSql(boolean condition, String tableAlias, Enum<?> field, String sqlValue) {
    if (condition) {
      return this.geSql(tableAlias, field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 &lt; ( sql语句 )
   *
   * <p>例1: ltSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: ltSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  @Override
  public C ltSql(boolean condition, String field, String sqlValue) {
    if (condition) {
      return this.ltSql(field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 &lt; ( sql语句 )
   *
   * <p>例1: ltSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: ltSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  @Override
  public C ltSql(boolean condition, Enum<?> field, String sqlValue) {
    if (condition) {
      return this.ltSql(field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 &lt; ( sql语句 )
   *
   * <p>例1: ltSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: ltSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  @Override
  public C ltSql(boolean condition, String tableAlias, Enum<?> field, String sqlValue) {
    if (condition) {
      return this.ltSql(tableAlias, field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 <= ( sql语句 )
   *
   * <p>例1: leSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: leSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段名
   * @param sqlValue sql语句
   * @return 具体实现
   */
  @Override
  public C leSql(boolean condition, String field, String sqlValue) {
    if (condition) {
      return this.leSql(field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 <= ( sql语句 )
   *
   * <p>例1: leSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: leSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  @Override
  public C leSql(boolean condition, Enum<?> field, String sqlValue) {
    if (condition) {
      return this.leSql(field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 <= ( sql语句 )
   *
   * <p>例1: leSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例1: leSql("id", "select id from table where name = 'JunJun'")
   *
   * @param condition 条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return 具体实现
   */
  @Override
  public C leSql(boolean condition, String tableAlias, Enum<?> field, String sqlValue) {
    if (condition) {
      return this.leSql(tableAlias, field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 IN ( sql语句 )
   *
   * <p>!! sql 注入方式的 in 方法 !!
   *
   * <p>例1: inSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例2: inSql("id", "select id from table where id &lt; 3")
   *
   * @param condition 执行条件
   * @param field 字段
   * @param sqlValue sql语句
   * @return children
   */
  @Override
  public C inSql(boolean condition, String field, String sqlValue) {
    if (condition) {
      return this.inSql(field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 IN ( sql语句 )
   *
   * <p>!! sql 注入方式的 in 方法 !!
   *
   * <p>例1: inSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例2: inSql("id", "select id from table where id &lt; 3")
   *
   * @param condition 执行条件
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return children
   */
  @Override
  public C inSql(boolean condition, Enum<?> field, String sqlValue) {
    if (condition) {
      return this.inSql(field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 IN ( sql语句 )
   *
   * <p>!! sql 注入方式的 in 方法 !!
   *
   * <p>例1: inSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例2: inSql("id", "select id from table where id &lt; 3")
   *
   * @param condition 执行条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句
   * @return children
   */
  @Override
  public C inSql(boolean condition, String tableAlias, Enum<?> field, String sqlValue) {
    if (condition) {
      return this.inSql(tableAlias, field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 NOT IN ( sql语句 )
   *
   * <p>!! sql 注入方式的 not in 方法 !!
   *
   * <p>例1: notInSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例2: notInSql("id", "select id from table where id &lt; 3")
   *
   * @param condition 执行条件
   * @param field 字段
   * @param sqlValue sql语句 ---&gt; 1,2,3,4,5,6 或者 select id from table where id &lt; 3
   * @return children
   */
  @Override
  public C notInSql(boolean condition, String field, String sqlValue) {
    if (condition) {
      return this.notInSql(field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 NOT IN ( sql语句 )
   *
   * <p>!! sql 注入方式的 not in 方法 !!
   *
   * <p>例1: notInSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例2: notInSql("id", "select id from table where id &lt; 3")
   *
   * @param condition 执行条件
   * @param field 字段枚举
   * @param sqlValue sql语句 ---&gt; 1,2,3,4,5,6 或者 select id from table where id &lt; 3
   * @return children
   */
  @Override
  public C notInSql(boolean condition, Enum<?> field, String sqlValue) {
    if (condition) {
      return this.notInSql(field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 NOT IN ( sql语句 )
   *
   * <p>!! sql 注入方式的 not in 方法 !!
   *
   * <p>例1: notInSql("id", "1, 2, 3, 4, 5, 6")
   *
   * <p>例2: notInSql("id", "select id from table where id &lt; 3")
   *
   * @param condition 执行条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @param sqlValue sql语句 ---&gt; 1,2,3,4,5,6 或者 select id from table where id &lt; 3
   * @return children
   */
  @Override
  public C notInSql(boolean condition, String tableAlias, Enum<?> field, String sqlValue) {
    if (condition) {
      return this.notInSql(tableAlias, field, sqlValue);
    }

    return this.childThis;
  }

  /**
   * 字段 IS NULL
   *
   * <p>例: isNull("name")
   *
   * @param condition 执行条件
   * @param field 字段
   * @return children
   */
  @Override
  public C isNull(boolean condition, String field) {
    if (condition) {
      return this.isNull(field);
    }

    return this.childThis;
  }

  /**
   * 字段 IS NULL
   *
   * <p>例: isNull("name")
   *
   * @param condition 执行条件
   * @param field 字段枚举
   * @return children
   */
  @Override
  public C isNull(boolean condition, Enum<?> field) {
    if (condition) {
      return this.isNull(field);
    }

    return this.childThis;
  }

  /**
   * 字段 IS NULL
   *
   * <p>例: isNull("name")
   *
   * @param condition 执行条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @return children
   */
  @Override
  public C isNull(boolean condition, String tableAlias, Enum<?> field) {
    if (condition) {
      return this.isNull(tableAlias, field);
    }

    return this.childThis;
  }

  /**
   * 字段 IS NOT NULL
   *
   * <p>例: isNotNull("name")
   *
   * @param condition 执行条件
   * @param field 字段
   * @return children
   */
  @Override
  public C isNotNull(boolean condition, String field) {
    if (condition) {
      return this.isNotNull(field);
    }

    return this.childThis;
  }

  /**
   * 字段 IS NOT NULL
   *
   * <p>例: isNotNull("name")
   *
   * @param condition 执行条件
   * @param field 字段枚举
   * @return children
   */
  @Override
  public C isNotNull(boolean condition, Enum<?> field) {
    if (condition) {
      return this.isNotNull(field);
    }

    return this.childThis;
  }

  /**
   * 字段 IS NOT NULL
   *
   * <p>例: isNotNull("name")
   *
   * @param condition 执行条件
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @return children
   */
  @Override
  public C isNotNull(boolean condition, String tableAlias, Enum<?> field) {
    if (condition) {
      return this.isNotNull(tableAlias, field);
    }

    return this.childThis;
  }

  /**
   * 拼接 sql
   *
   * <p>!! 会有 sql 注入风险 !!
   *
   * <p>例1: expression("id = 1")
   *
   * <p>例2: expression("date_format(dateColumn,'%Y-%m-%d') = '2008-08-08'")
   *
   * <p>例3: expression("date_format(dateColumn,'%Y-%m-%d') = {0}", LocalDate.now())
   *
   * @param condition 执行条件
   * @param sqlValue sql语句
   * @param values 数据数组
   * @return children
   */
  @Override
  public C expression(boolean condition, String sqlValue, Object... values) {
    if (condition) {
      return this.expression(sqlValue, values);
    }

    return this.childThis;
  }

  /**
   * 拼接 EXISTS ( sql语句 )
   *
   * <p>!! sql 注入方法 !!
   *
   * <p>例: exists("select id from table where age = 1")
   *
   * @param condition 执行条件
   * @param sqlValue sql语句
   * @param values 数据数组
   * @return children
   */
  @Override
  public C exists(boolean condition, String sqlValue, Object... values) {
    if (condition) {
      return this.exists(sqlValue, values);
    }

    return this.childThis;
  }

  /**
   * 拼接 NOT EXISTS ( sql语句 )
   *
   * <p>!! sql 注入方法 !!
   *
   * <p>例: notExists("select id from table where age = 1")
   *
   * @param condition 执行条件
   * @param sqlValue sql语句
   * @param values 数据数组
   * @return children
   */
  @Override
  public C notExists(boolean condition, String sqlValue, Object... values) {
    if (condition) {
      return this.notExists(sqlValue, values);
    }

    return this.childThis;
  }

  /**
   * 应用action消费器
   *
   * @param condition 条件
   * @param actionConsumer action消费器
   * @return 具体实现
   */
  @Override
  public C apply(boolean condition, Consumer<C> actionConsumer) {
    if (condition) {
      return this.apply(actionConsumer);
    }

    return this.childThis;
  }

  /**
   * 拼接 OR
   *
   * @param condition 执行条件
   * @return children
   */
  @Override
  public C or(boolean condition) {
    if (condition) {
      return this.or();
    }

    return this.childThis;
  }

  /**
   * OR 嵌套
   *
   * <p>例: or(i -&gt; i.eq("name", "李白").ne("status", "活着"))
   *
   * @param condition 执行条件
   * @param consumer 消费函数
   * @return children
   */
  @Override
  public C or(boolean condition, Consumer<C> consumer) {
    if (condition) {
      return this.or(consumer);
    }

    return this.childThis;
  }

  /**
   * AND 嵌套
   *
   * <p>例: and(i -&gt; i.eq("name", "李白").ne("status", "活着"))
   *
   * @param condition 执行条件
   * @param consumer 消费函数
   * @return children
   */
  @Override
  public C and(boolean condition, Consumer<C> consumer) {
    if (condition) {
      return this.and(consumer);
    }

    return this.childThis;
  }

  /**
   * 正常嵌套 不带 AND 或者 OR
   *
   * <p>例: nested(i -&gt; i.eq("name", "李白").ne("status", "活着"))
   *
   * @param condition 执行条件
   * @param consumer 消费函数
   * @return children
   */
  @Override
  public C nested(boolean condition, Consumer<C> consumer) {
    if (condition) {
      return this.nested(consumer);
    }

    return this.childThis;
  }
}
