package org.elsfs.tool.sql.mybatisplus.extension;

import java.io.Serializable;
import java.util.Collection;
import org.elsfs.tool.core.text.StrUtils;
import org.elsfs.tool.sql.interfaces.Join;
import org.elsfs.tool.sql.utils.SqlPool;

/**
 * JOIN查询拓展接口
 *
 * @param <C> 子类具体类型
 * @param <JB> JOIN构建器类型
 * @param <JCB> JOIN条件构建器类型
 * @author zeng
 * @since 0.0.4
 */
public interface JoinWrapper<
        C extends JoinWrapper<C, JB, JCB>,
        JB extends Join.JoinBuilder<JB, JCB, C>,
        JCB extends Join.JoinConditionBuilder<JCB, JB, C>>
    extends Join<C, JB, JCB>, Serializable {

  /** 选择字段分隔符 */
  String FIELD_SEPARATOR = SqlPool.COMMA_WITH_SPACE;

  /** 主表别名前缀 */
  String TABLE_ALIAS_PREFIX = "t" + SqlPool.DOT;

  /**
   * 获取JOIN的SQL片段
   *
   * @return SQL片段
   */
  String getJoinSqlSegment();

  /**
   * 是否已清空默认的选择字段
   *
   * @return bool
   */
  boolean isClearedDefaultSelectedFields();

  /**
   * 清空默认的选择字段
   *
   * @return this
   */
  C clearDefaultSelectedFields();

  /**
   * 合并SQL选择字段
   *
   * @param existedFields 已存在字段
   * @param newFields 新的选择字段
   * @return 合并后的选择字段
   */
  static String mergeSelectedFields(String existedFields, String[] newFields) {
    if (StrUtils.isNotBlank(existedFields)) {
      return existedFields + FIELD_SEPARATOR + String.join(FIELD_SEPARATOR, newFields);
    } else {
      return String.join(FIELD_SEPARATOR, newFields);
    }
  }

  /**
   * 合并SQL选择字段
   *
   * @param existedFields 已存在字段
   * @param newFields 新的选择字段
   * @return 合并后的选择字段
   */
  static String mergeSelectedFields(String existedFields, Collection<String> newFields) {
    if (StrUtils.isNotBlank(existedFields)) {
      return existedFields + FIELD_SEPARATOR + String.join(FIELD_SEPARATOR, newFields);
    } else {
      return String.join(FIELD_SEPARATOR, newFields);
    }
  }
}
