package org.elsfs.tool.sql.mybatisplus.mybatis;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import java.util.List;
import org.elsfs.tool.sql.exception.SqlBuilderException;
import org.elsfs.tool.sql.interfaces.TableAliasManager;
import org.elsfs.tool.sql.mybatisplus.extension.JoinQueryWrapper;
import org.elsfs.tool.sql.mybatisplus.mapper.ElsfsMapper;
import org.elsfs.tool.sql.singular.facade.QueryAction;
import org.elsfs.tool.sql.utils.CastUtils;

/**
 * JOIN多记录查询动作
 *
 * @param <E> 实体类型
 * @author zeng
 * @since 0.0.4
 */
public class ListMybatisPlusQueryAction<E> extends AbstractMybatisPlusQueryAction<E, List<E>> {

  /** 基础Mapper */
  protected final ElsfsMapper<E> vefMapper;

  public ListMybatisPlusQueryAction(
      JoinQueryWrapper<E> queryWrapper,
      ElsfsMapper<E> vefMapper,
      TableAliasManager tableAliasManager) {
    super(queryWrapper, tableAliasManager);
    this.vefMapper = vefMapper;
  }

  /**
   * 执行动作
   *
   * @return 结果
   */
  @Override
  public List<E> execute() {
    if (this.vefMapper == null) {
      throw new SqlBuilderException("嵌套查询条件设置Action不支持execute操作");
    }

    if (this.page != null) {
      this.limit(this.page.getPageSize());
    }
    List<E> entities = this.vefMapper.selectJoinList(this.wrapper);

    return entities;
  }

  /**
   * 获取操作Action实例
   *
   * @param wrapper 条件Wrapper对象
   * @return Action实例
   */
  @Override
  protected QueryAction<List<E>> instance(Wrapper<E> wrapper) {
    return new ListMybatisPlusQueryAction<>(CastUtils.cast(wrapper), null, this.tableAliasManager);
  }
}
