package org.elsfs.tool.sql.mybatisplus.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

/**
 * 布尔值处理器
 *
 * @author zeng
 * @since 0.0.4
 */
public class BooleanTypeHandler extends BaseTypeHandler<Boolean> {

  /**
   * 设置参数
   *
   * @param ps 预处理语句
   * @param i 参数下标
   * @param parameter 参数值
   * @param jdbcType 类型
   * @throws SQLException 异常
   */
  @Override
  public void setNonNullParameter(PreparedStatement ps, int i, Boolean parameter, JdbcType jdbcType)
      throws SQLException {
    ps.setInt(i, parameter ? 1 : 0);
  }

  /**
   * Gets the nullable result.
   *
   * @param rs the rs
   * @param columnName Column name, when configuration <code>useColumnLabel</code> is <code>false
   *     </code>
   * @return the nullable result
   * @throws SQLException the SQL exception
   */
  @Override
  public Boolean getNullableResult(ResultSet rs, String columnName) throws SQLException {
    return rs.getInt(columnName) == 1;
  }

  /**
   * 获取可空结果
   *
   * @param rs 结果集
   * @param columnIndex 列下标
   * @return 结果
   * @throws SQLException 异常
   */
  @Override
  public Boolean getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
    return rs.getInt(columnIndex) == 1;
  }

  /**
   * 获取可空结果
   *
   * @param cs 调用过程
   * @param columnIndex 列下标
   * @return 结果
   * @throws SQLException 异常
   */
  @Override
  public Boolean getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
    return cs.getInt(columnIndex) == 1;
  }
}
