package org.elsfs.tool.sql.mybatisplus.utils;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import java.util.function.Predicate;

/**
 * 谓词持有器
 *
 * @author zeng
 * @since 0.0.4
 */
public final class PredicateHolder {

  /** 存储谓词判断器 */
  private static final ThreadLocal<Predicate<TableFieldInfo>> PREDICATE_THREAD_LOCAL =
      new ThreadLocal<>();

  /**
   * 获取谓词
   *
   * @return 谓词
   */
  public static Predicate<TableFieldInfo> get() {
    return PREDICATE_THREAD_LOCAL.get();
  }

  /**
   * 设置谓词
   *
   * @param predicate 谓词
   */
  public static void set(Predicate<TableFieldInfo> predicate) {
    PREDICATE_THREAD_LOCAL.set(predicate);
  }

  /** 移除谓词 */
  public static void remove() {
    PREDICATE_THREAD_LOCAL.remove();
  }
}
