package org.elsfs.tool.sql.mybatisplus.mapper;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * the is {@link ElsfsMapper}
 *
 * @author zeng
 * @since 0.0.4
 */
public interface ElsfsMapper<T> extends BaseMapper<T> {

  /**
   * 根据ID判断是否存在
   *
   * @param id 主键ID
   * @return bool 是否存在
   */
  Boolean existsById(String id);

  /**
   * 根据构建条件判断是否存在记录
   *
   * @param queryWrapper 查询条件构造器
   * @return bool 是否存在
   */
  Boolean existsByWrapper(@Param(Constants.WRAPPER) Wrapper<T> queryWrapper);

  /**
   * 根据构建JOIN条件判断是否存在记录
   *
   * @param joinQueryWrapper JOIN查询条件构造器
   * @return bool 是否存在
   */
  Boolean existsByJoinWrapper(@Param(Constants.WRAPPER) Wrapper<T> joinQueryWrapper);

  /**
   * 根据 Wrapper 条件，查询总记录数
   *
   * @param joinQueryWrapper 实体对象封装操作类（可以为 null）
   * @return 数量
   */
  Long selectJoinCount(@Param(Constants.WRAPPER) Wrapper<T> joinQueryWrapper);

  /**
   * 根据 entity 条件，查询全部记录
   *
   * @param joinQueryWrapper 实体对象封装操作类（可以为 null）
   * @return 实体对象
   */
  T selectJoinOne(@Param(Constants.WRAPPER) Wrapper<T> joinQueryWrapper);

  /**
   * 根据 entity 条件，查询全部记录
   *
   * @param joinQueryWrapper 实体对象封装操作类（可以为 null）
   * @return 实体记录列表
   */
  List<T> selectJoinList(@Param(Constants.WRAPPER) Wrapper<T> joinQueryWrapper);

  /**
   * 根据 entity 条件，查询全部记录（并翻页）
   *
   * @param page 分页查询条件（可以为 RowBounds.DEFAULT）
   * @param joinQueryWrapper 实体对象封装操作类（可以为 null）
   * @param <P> 分页对象类型
   * @return 分页数据
   */
  <P extends IPage<T>> P selectJoinPage(
    P page, @Param(Constants.WRAPPER) Wrapper<T> joinQueryWrapper);
}
