package org.elsfs.tool.sql.mybatisplus.method;

import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.elsfs.tool.sql.mybatisplus.extension.JoinWrapper;
import org.elsfs.tool.sql.utils.SqlPool;

/**
 * 根据Join查询判断记录是否存在
 *
 * @author zeng
 * @since 0.0.4
 */
public class ExistsByJoinWrapper extends AbstractJoinMethod {

  /** SQL脚本 */
  private static final String SQL_SCRIPT =
      "<script>%s SELECT 1 FROM %s %s %s LIMIT 1 %s\n</script>";

  public ExistsByJoinWrapper() {
    super("existsByJoinWrapper");
  }

  /**
   * 注入自定义 MappedStatement
   *
   * @param mapperClass mapper 接口
   * @param modelClass mapper 泛型
   * @param tableInfo 数据库表反射信息
   * @return MappedStatement
   */
  @Override
  public MappedStatement injectMappedStatement(
      Class<?> mapperClass, Class<?> modelClass, TableInfo tableInfo) {
    String sql =
        String.format(
            SQL_SCRIPT,
            this.sqlFirst(),
            tableInfo.getTableName() + SqlPool.AS_KEYWORD_WITH_SPACE + JoinWrapper.TABLE_ALIAS,
            SqlScriptUtils.unSafeParam(JOIN_SQL_METHOD),
            this.sqlWhereEntityWrapper(true, tableInfo),
            this.sqlComment());

    SqlSource sqlSource = languageDriver.createSqlSource(configuration, sql, modelClass);
    return this.addSelectMappedStatementForOther(
        mapperClass, this.methodName, sqlSource, Boolean.class);
  }
}
