package org.elsfs.tool.sql.mybatisplus.mybatis;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import org.elsfs.tool.sql.exception.SqlBuilderException;
import org.elsfs.tool.sql.interfaces.TableAliasManager;
import org.elsfs.tool.sql.mybatisplus.extension.JoinQueryWrapper;
import org.elsfs.tool.sql.mybatisplus.mapper.ElsfsMapper;
import org.elsfs.tool.sql.singular.facade.QueryAction;
import org.elsfs.tool.sql.utils.CastUtils;

/**
 * 统计JOIN查询动作
 *
 * @param <E> 实体类型
 * @author zeng
 * @since 0.0.4
 */
public class CountMybatisPlusQueryAction<E> extends AbstractMybatisPlusQueryAction<E, Long> {

  /** 基础Mapper */
  protected final ElsfsMapper<E> vefMapper;

  public CountMybatisPlusQueryAction(
      JoinQueryWrapper<E> queryWrapper,
      ElsfsMapper<E> vefMapper,
      TableAliasManager tableAliasManager) {
    super(queryWrapper, tableAliasManager);
    this.vefMapper = vefMapper;
  }

  /**
   * 执行动作
   *
   * @return 结果
   */
  @Override
  public Long execute() {
    if (this.vefMapper == null) {
      throw new SqlBuilderException("嵌套查询条件设置Action不支持execute操作");
    }

    return this.vefMapper.selectJoinCount(this.wrapper);
  }

  /**
   * 获取操作Action实例
   *
   * @param wrapper 条件Wrapper对象
   * @return Action实例
   */
  @Override
  protected QueryAction<Long> instance(Wrapper<E> wrapper) {
    return new CountMybatisPlusQueryAction<>(CastUtils.cast(wrapper), null, this.tableAliasManager);
  }
}
