package org.elsfs.tool.sql.mybatisplus.mybatis;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import org.elsfs.tool.sql.exception.SqlBuilderException;
import org.elsfs.tool.sql.interfaces.TableAliasManager;
import org.elsfs.tool.sql.mybatisplus.extension.JoinQueryWrapper;
import org.elsfs.tool.sql.mybatisplus.mapper.ElsfsMapper;
import org.elsfs.tool.sql.singular.facade.QueryAction;
import org.elsfs.tool.sql.utils.CastUtils;

/**
 * 存在JOIN查询动作
 *
 * @param <E> 实体类型
 * @author zeng
 * @since 0.0.4
 */
public class ExistsMybatisPlusQueryAction<E> extends AbstractMybatisPlusQueryAction<E, Boolean> {

  /** 基础Mapper */
  protected final ElsfsMapper<E> vefMapper;

  public ExistsMybatisPlusQueryAction(
      JoinQueryWrapper<E> queryWrapper,
      ElsfsMapper<E> vefMapper,
      TableAliasManager tableAliasManager) {
    super(queryWrapper, tableAliasManager);
    this.vefMapper = vefMapper;
  }

  /**
   * 执行动作
   *
   * @return 结果
   */
  @Override
  public Boolean execute() {
    if (this.vefMapper == null) {
      throw new SqlBuilderException("嵌套查询条件设置Action不支持execute操作");
    }

    return Boolean.TRUE.equals(this.vefMapper.existsByJoinWrapper(this.wrapper));
  }

  /**
   * 获取操作Action实例
   *
   * @param wrapper 条件Wrapper对象
   * @return Action实例
   */
  @Override
  protected QueryAction<Boolean> instance(Wrapper<E> wrapper) {
    return new ExistsMybatisPlusQueryAction<>(
        CastUtils.cast(wrapper), null, this.tableAliasManager);
  }
}
