package org.elsfs.tool.sql.mybatisplus.mybatis;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.elsfs.tool.sql.exception.SqlBuilderException;
import org.elsfs.tool.sql.mybatisplus.mapper.ElsfsMapper;
import org.elsfs.tool.sql.singular.facade.DeletionAction;
import org.elsfs.tool.sql.utils.SqlPool;

/**
 * 删除动作实现
 *
 * @param <E> 实体类型
 * @author zeng
 * @since 0.0.4
 */
public class MybatisPlusDeletionAction<E>
    extends AbstractMybatisPlusConditionOperations<DeletionAction<Long>, E>
    implements DeletionAction<Long> {

  /** 基础Mapper */
  protected final ElsfsMapper<E> elsfsMapper;

  /** 执行钩子 */
  protected boolean hookExecution = true;

  public MybatisPlusDeletionAction(QueryWrapper<E> queryWrapper, ElsfsMapper<E> elsfsMapper) {
    super(queryWrapper);
    this.elsfsMapper = elsfsMapper;
  }

  /**
   * 禁用钩子执行
   *
   * @return Action实例
   */
  public DeletionAction<Long> disableHookExecution() {
    this.hookExecution = false;
    return this;
  }

  /**
   * 执行动作
   *
   * @return 结果
   */
  @Override
  public Long execute() {
    if (this.elsfsMapper == null) {
      throw new SqlBuilderException("嵌套查询条件设置Action不支持execute操作");
    }

    return (long) this.elsfsMapper.delete(this.wrapper);
  }

  /**
   * 解析字段枚举名称
   *
   * @param field 字段枚举
   * @return 字段名称
   */
  @Override
  public String resolveFieldName(Enum<?> field) {
    return field.name();
  }

  /**
   * 解析字段枚举名称
   *
   * @param tableAlias 字段表别名
   * @param field 字段枚举
   * @return 字段名称
   */
  @Override
  public String resolveFieldName(String tableAlias, Enum<?> field) {
    return tableAlias + SqlPool.DOT + field.name();
  }

  /**
   * 获取操作Action实例
   *
   * @param wrapper 条件Wrapper对象
   * @return Action实例
   */
  @Override
  protected DeletionAction<Long> instance(Wrapper<E> wrapper) {
    if (wrapper instanceof QueryWrapper<E> queryWrapper) {
      return new MybatisPlusDeletionAction<>(queryWrapper, null);
    }

    return new MybatisPlusDeletionAction<>(null, null);
  }
}
