package org.elsfs.tool.sql.mybatisplus.mybatis;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import java.util.List;
import org.elsfs.tool.sql.exception.SqlBuilderException;
import org.elsfs.tool.sql.interfaces.TableAliasManager;
import org.elsfs.tool.sql.mybatisplus.extension.JoinQueryWrapper;
import org.elsfs.tool.sql.mybatisplus.mapper.ElsfsMapper;
import org.elsfs.tool.core.page.IPage;
import org.elsfs.tool.core.page.Page;
import org.elsfs.tool.sql.singular.facade.QueryAction;
import org.elsfs.tool.sql.utils.CastUtils;

/**
 * JOIN分页查询动作
 *
 * @param <E> 实体类型
 * @author zeng
 * @since 0.0.4
 */
public class PageMybatisPlusQueryAction<E> extends AbstractMybatisPlusQueryAction<E, IPage<E>> {

  /** 基础Mapper */
  protected final ElsfsMapper<E> elsfsMapper;

  public PageMybatisPlusQueryAction(
      JoinQueryWrapper<E> queryWrapper,
      ElsfsMapper<E> elsfsMapper,
      TableAliasManager tableAliasManager) {
    super(queryWrapper, tableAliasManager);
    this.elsfsMapper = elsfsMapper;
  }

  /**
   * 执行动作
   *
   * @return 结果
   */
  @Override
  public Page<E> execute() {
    if (this.elsfsMapper == null) {
      throw new SqlBuilderException("嵌套查询条件设置Action不支持execute操作");
    }

    if (this.page == null) {
      throw new SqlBuilderException("分页Join查询必须设置分页信息");
    }
    PageImpl<E> pageRes = new PageImpl<E>();
    PageImpl<E> selectJoinPage = this.elsfsMapper.selectJoinPage(pageRes, this.wrapper);

    var entities = selectJoinPage.getRecords();
    return new Page<>();
  }

  /**
   * 获取操作Action实例
   *
   * @param wrapper 条件Wrapper对象
   * @return Action实例
   */
  @Override
  protected QueryAction<IPage<E>> instance(Wrapper<E> wrapper) {
    return new PageMybatisPlusQueryAction<>(CastUtils.cast(wrapper), null, this.tableAliasManager);
  }

  /**
   * page
   *
   * @param <E> 类型
   */
  public class PageImpl<E> implements com.baomidou.mybatisplus.core.metadata.IPage<E> {

    /**
     * 获取排序信息，排序的字段和正反序
     *
     * @return 排序信息
     */
    @Override
    public List<OrderItem> orders() {
      return null;
    }

    /**
     * 分页记录列表
     *
     * @return 分页对象记录列表
     */
    @Override
    public List<E> getRecords() {
      return null;
    }

    /**
     * 设置分页记录列表
     *
     * @param records res
     */
    @Override
    public com.baomidou.mybatisplus.core.metadata.IPage<E> setRecords(List<E> records) {
      return null;
    }

    /**
     * 当前满足条件总行数
     *
     * @return 总条数
     */
    @Override
    public long getTotal() {
      return 0;
    }

    /**
     * 设置当前满足条件总行数
     *
     * @param total t
     */
    @Override
    public com.baomidou.mybatisplus.core.metadata.IPage<E> setTotal(long total) {
      return null;
    }

    /**
     * 获取每页显示条数
     *
     * @return 每页显示条数
     */
    @Override
    public long getSize() {
      return 0;
    }

    /**
     * 设置每页显示条数
     *
     * @param size s
     */
    @Override
    public com.baomidou.mybatisplus.core.metadata.IPage<E> setSize(long size) {
      return null;
    }

    /**
     * 当前页
     *
     * @return 当前页
     */
    @Override
    public long getCurrent() {
      return 0;
    }

    /**
     * 设置当前页
     *
     * @param current c
     */
    @Override
    public com.baomidou.mybatisplus.core.metadata.IPage<E> setCurrent(long current) {
      return null;
    }
  }
}
